/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.utils;

import com.huawei.ism.tool.devicemanager.ui.action.support.SubDialogUtils;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.JDialog;

public class DeviceForbidLoginUtil {
    private static String[] FORBID_ADRESS = new String[]{"172.31.128.101", "172.31.128.102"};
    private static String[] FORBID_DEV_TYPES = new String[]{"Dorado6000 V3"};
    private static String[] FORBID_NVME_DEV_TYPES = new String[]{"Dorado5000 V3"};

    public static boolean isForbidDev(DevNode devNode) throws ToolException {
        return DeviceForbidLoginUtil.isForbidIp(devNode) && DeviceForbidLoginUtil.isForbidDevType(devNode);
    }

    public static List<com.huawei.ism.tool.framework.pubservice.entity.DevNode> filterForbidDevContainsShowErrMsg(List<com.huawei.ism.tool.framework.pubservice.entity.DevNode> devNodes) {
        if (devNodes == null) {
            return null;
        }
        Iterator<com.huawei.ism.tool.framework.pubservice.entity.DevNode> devNodesItr = devNodes.iterator();
        ArrayList<ArrayList<Object>> failRet = new ArrayList<ArrayList<Object>>();
        while (devNodesItr.hasNext()) {
            com.huawei.ism.tool.framework.pubservice.entity.DevNode node = devNodesItr.next();
            try {
                if (!DeviceForbidLoginUtil.isForbidDev(EntityUtils.toOldDev((com.huawei.ism.tool.framework.pubservice.entity.DevNode)node))) continue;
                failRet.add(DeviceForbidLoginUtil.createFailRet(node.getIp(), DeviceForbidLoginUtil.createErrMsg(EntityUtils.toOldDev((com.huawei.ism.tool.framework.pubservice.entity.DevNode)node))));
                devNodesItr.remove();
            }
            catch (ToolException e) {
                failRet.add(DeviceForbidLoginUtil.createFailRet(node.getIp(), e.getDes()));
                devNodesItr.remove();
            }
        }
        if (failRet.size() != 0) {
            DeviceForbidLoginUtil.showForbidErrMsgBlockMainThread(failRet);
        }
        return devNodes;
    }

    private static ArrayList<Object> createFailRet(String ip, String msg) {
        ArrayList<Object> failRet = new ArrayList<Object>();
        failRet.add(ip);
        failRet.add(msg);
        return failRet;
    }

    private static void showForbidErrMsgBlockMainThread(ArrayList<ArrayList<Object>> failRet) {
        JDialog parent = new JDialog();
        SubDialogUtils.showMultiInfoDialog((Window)parent, ResourceUtil.getString((String)"devicemanager.device.add.failed"), new String[]{ResourceUtil.getString((String)"devicemanager.layout.device.tablecolume.devip"), ResourceUtil.getString((String)"scene.remind.errormessage.reason")}, failRet);
    }

    public static String createErrMsg(DevNode devNode) {
        return ResourceUtil.getStringWithParams((String)"devicemanager.device.forbid.dev", (Object[])new Object[]{devNode.getIp(), String.join((CharSequence)" ,", FORBID_ADRESS)});
    }

    private static boolean isForbidIp(DevNode devNode) {
        return Arrays.stream(FORBID_ADRESS).anyMatch(ip -> ip.equals(devNode.getIp()));
    }

    private static boolean isForbidDevType(DevNode devNode) throws ToolException {
        return Arrays.stream(FORBID_DEV_TYPES).anyMatch(productModel -> devNode.getDeviceType() != null && productModel.equals(devNode.getDeviceType().toString())) || DeviceForbidLoginUtil.isForbidNVMeDevType(devNode);
    }

    private static boolean isForbidNVMeDevType(DevNode devNode) throws ToolException {
        return Arrays.stream(FORBID_NVME_DEV_TYPES).anyMatch(productModel -> devNode.getDeviceType() != null && productModel.equals(devNode.getDeviceType().toString())) && DeviceForbidLoginUtil.isNVMeDev(devNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isNVMeDev(DevNode devNode) throws ToolException {
        ICliConnection con = null;
        try {
            con = SshConnectionManager.getSshConnection((DevNode)devNode, null, (boolean)true, (boolean)true);
            String originInfo = con.execCmd("show enclosure");
            String[] lines = originInfo.split("\n");
            int titleLineIndex = DeviceForbidLoginUtil.findTitleLineIndex(lines);
            int logicTypeTitleIndex = DeviceForbidLoginUtil.findTitleNameIndex(lines[titleLineIndex], "Logic Type");
            int typeTitleIndex = DeviceForbidLoginUtil.findTitleNameIndex(lines[titleLineIndex], "Type");
            for (int index = titleLineIndex + 1; index < lines.length; ++index) {
                String[] values = DeviceForbidLoginUtil.splitLine(lines[index]);
                if (logicTypeTitleIndex >= values.length || typeTitleIndex >= values.length || !"Engine".equals(values[logicTypeTitleIndex].trim()) || !values[typeTitleIndex].contains("NVMe")) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (con != null) {
                SshConnectionManager.releaseConnection((ICliConnection)con);
            }
        }
    }

    private static int findTitleLineIndex(String[] lines) throws ToolException {
        Pattern r = Pattern.compile("^[ |-]*$");
        for (int index = 0; index < lines.length; ++index) {
            if (!r.matcher(lines[index]).find() || !lines[index].contains("-")) continue;
            return index - 1;
        }
        throw new ToolException("devicemanager.device.add.failed");
    }

    private static int findTitleNameIndex(String titleLine, String titleName) throws ToolException {
        String[] infoList = DeviceForbidLoginUtil.splitLine(titleLine);
        for (int index = 0; index < infoList.length; ++index) {
            if (!titleName.equals(infoList[index].trim())) continue;
            return index;
        }
        throw new ToolException("devicemanager.device.add.failed");
    }

    private static String[] splitLine(String line) {
        return (String[])Arrays.stream(line.split(" {2}")).map(String::trim).filter(str -> !StringUtils.isNULLStr((String)str)).toArray(String[]::new);
    }
}

