/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.utils;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.devicemanager.service.task.PsdValidator;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.slf4j.Logger;

public class PsdValidatorHelper {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(PsdValidatorHelper.class);

    public static TaskResult checkDevNodePsw(DevNode devNode) {
        if (null == devNode || null == devNode.getPriKey() || StringUtils.isNULLStr((String)devNode.getLoginUser().getPassword())) {
            LOGGER.info("no password need to validate");
            return new TaskResult(TaskResult.Result.CANCELED);
        }
        return new PsdValidator(devNode).validate();
    }

    public static Future<TaskResult> checkDevNodePswWithFuture(DevNode devNode) {
        if (null == devNode || null == devNode.getPriKey() || StringUtils.isNULLStr((String)devNode.getLoginUser().getPassword())) {
            LOGGER.info("no password need to validate");
            return null;
        }
        return AsyncExcutor.submit((Callable)new PsdCheckTask(devNode));
    }

    private static class PsdCheckTask
    implements Callable<TaskResult> {
        private DevNode devNode;

        public PsdCheckTask(DevNode devNode) {
            this.devNode = devNode;
        }

        @Override
        public TaskResult call() throws Exception {
            return PsdValidatorHelper.checkDevNodePsw(this.devNode);
        }
    }
}

