/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.entity;

import com.huawei.ism.tool.loganalyzer.entity.EventIssue;
import com.huawei.ism.tool.loganalyzer.entity.analyze.ReportLog;
import com.huawei.ism.tool.loganalyzer.faulttree.command.model.DateInfo;
import com.huawei.ism.tool.loganalyzer.faulttree.model.DeviceType;
import com.huawei.ism.tool.loganalyzer.faulttree.resources.model.Issue;
import com.huawei.ism.tool.loganalyzer.faulttree.rulesearch.model.CauseMatchResult;
import com.huawei.ism.tool.loganalyzer.faulttree.rulesearch.model.RecordInfo;
import com.huawei.ism.tool.loganalyzer.faulttree.rulesearch.model.ResultCombination;
import com.huawei.ism.tool.loganalyzer.util.SearcherUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FaultTreeData {
    private DeviceType type;

    public FaultTreeData(DeviceType type) {
        this.type = type;
    }

    public List<ReportLog> getReportLog(Map<String, CauseMatchResult> causeMatchResultMap) {
        ArrayList<ReportLog> reportLoglist = new ArrayList<ReportLog>();
        Set<Map.Entry<String, CauseMatchResult>> set = causeMatchResultMap.entrySet();
        for (Map.Entry<String, CauseMatchResult> entry : set) {
            ReportLog reportLog;
            CauseMatchResult cmr = entry.getValue();
            if (cmr.getDateInfo() == null) {
                reportLog = this.getReportLog(cmr);
                reportLoglist.add(reportLog);
                continue;
            }
            if (!SearcherUtils.isOnSetDate(cmr.getDateInfo().getTime())) continue;
            reportLog = this.getReportLog(cmr);
            reportLoglist.add(reportLog);
        }
        SearcherUtils.replaceAllHelpLink(reportLoglist);
        return reportLoglist;
    }

    private ReportLog getReportLog(CauseMatchResult cmr) {
        ReportLog reportLog = new ReportLog();
        Issue issue = this.type.resourceCache().getIssue(cmr.getCauseId());
        EventIssue eventIssue = new EventIssue();
        eventIssue.setAction(issue.getAction());
        eventIssue.setCaseHref(issue.getCaseHref());
        eventIssue.setCaseName(issue.getCaseName());
        eventIssue.setCause(issue.getCause());
        eventIssue.setModle(issue.getModle());
        eventIssue.setName(issue.getName());
        eventIssue.setNo(issue.getNo());
        eventIssue.setVersion(issue.getVersion());
        reportLog.setDetail(eventIssue);
        reportLog.setId(cmr.getCauseId());
        reportLog.setName(eventIssue.getName());
        reportLog.setNo(eventIssue.getNo());
        if (cmr.getDateInfo() != null) {
            reportLog.setOccurTime(cmr.getDateInfo().getDate());
        } else {
            reportLog.setOccurTime("--");
        }
        reportLog.setRecordInfos(this.getRecordInfoList(cmr));
        return reportLog;
    }

    public void addKnownRiskLogs(List<ReportLog> knownRiskLogs, Map<String, CauseMatchResult> causeMatchResultMap) {
        for (ReportLog reportLog : knownRiskLogs) {
            CauseMatchResult cmr = new CauseMatchResult(null);
            String causeId = reportLog.getNo().trim();
            List<RecordInfo> recordInfoList = reportLog.getRecordInfos();
            this.setDateInfo(recordInfoList, reportLog.getOccurTime());
            ResultCombination rc = new ResultCombination(null);
            rc.add(recordInfoList);
            cmr.addResultCombination(rc);
            cmr.setCauseId(causeId);
            cmr.addRecordInfoList(causeId, recordInfoList);
            if (causeMatchResultMap.get(causeId) != null) continue;
            causeMatchResultMap.put(causeId, cmr);
        }
    }

    public void setDateInfo(List<RecordInfo> recordInfoList, String date) {
        DateInfo dateInfo = new DateInfo(date, this.parseDate(date));
        for (RecordInfo recordInfo : recordInfoList) {
            recordInfo.setDateInfo(dateInfo);
        }
    }

    private synchronized long parseDate(String dateStr) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            return format.parse(dateStr).getTime();
        }
        catch (ParseException e) {
            return 0L;
        }
    }

    private List<RecordInfo> getRecordInfoList(CauseMatchResult cmr) {
        ArrayList<RecordInfo> recordInfoList = new ArrayList<RecordInfo>();
        Set<String> keys = cmr.getRecordInfoMap().keySet();
        for (String key : keys) {
            recordInfoList.addAll((Collection<RecordInfo>)cmr.getRecordInfoMap().get(key));
        }
        return recordInfoList;
    }
}

