/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.entity.analyze;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.loganalyzer.entity.analyze.FileType;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public class LogFileSearchBean {
    private int fileType;
    private String ctrlName;
    private long startDate;
    private long endDate;
    private List<String> containKeywords;
    private List<String> notContainKeywords;
    private int pageSize;
    private int curPage;
    private int startFileIndex;
    private int startLineIndex;

    public int getStartFileIndex() {
        return this.startFileIndex;
    }

    public void setStartFileIndex(int startFileIndex) {
        this.startFileIndex = startFileIndex;
    }

    public int getStartLineIndex() {
        return this.startLineIndex;
    }

    public void setStartLineIndex(int startLineIndex) {
        this.startLineIndex = startLineIndex;
    }

    public int getFileType() {
        return this.fileType;
    }

    public void setFileType(int fileType) {
        this.fileType = fileType;
    }

    public String getCtrlName() {
        return this.ctrlName;
    }

    public void setCtrlName(String ctrlName) {
        this.ctrlName = ctrlName;
    }

    public long getStartDate() {
        return this.startDate;
    }

    public void setStartDate(long startDate) {
        this.startDate = startDate;
    }

    public long getEndDate() {
        return this.endDate;
    }

    public void setEndDate(long endDate) {
        this.endDate = endDate;
    }

    public List<String> getContainKeywords() {
        return this.containKeywords;
    }

    public void setContainKeywords(List<String> containKeywords) {
        this.containKeywords = containKeywords;
    }

    public List<String> getNotContainKeywords() {
        return this.notContainKeywords;
    }

    public void setNotContainKeywords(List<String> notContainKeywords) {
        this.notContainKeywords = notContainKeywords;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getCurPage() {
        return this.curPage;
    }

    public void setCurPage(int curPage) {
        this.curPage = curPage;
    }

    public boolean validDateRange(String lineStr) {
        if (this.startDate > 0L || this.endDate > 0L) {
            long startDateTmp = this.startDate;
            long endDateTmp = this.endDate == 0L ? Long.MAX_VALUE : this.endDate;
            String dateStr = FileType.transfer(this.fileType).getOriginalFileService().parseDate(lineStr);
            long date = 0L;
            if (StringUtils.isNULLStr((String)dateStr)) {
                return false;
            }
            date = this.parseDate2Long(dateStr, "yyyy-MM-dd HH:mm:ss");
            return startDateTmp <= date && date <= endDateTmp;
        }
        return true;
    }

    public boolean validContainsKeywords(String lineStr) {
        if (this.containKeywords != null) {
            for (String keyWord : this.containKeywords) {
                if (keyWord.trim().equals("") || !lineStr.contains(keyWord)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean validNotContainsKeywords(String lineStr) {
        if (this.notContainKeywords != null) {
            for (String keyWord : this.notContainKeywords) {
                if (keyWord.trim().equals("") || !lineStr.contains(keyWord)) continue;
                return true;
            }
        }
        return false;
    }

    public long parseDate2Long(String dateStr, String dateStrStyle) {
        SimpleDateFormat format = new SimpleDateFormat(dateStrStyle);
        try {
            format.setLenient(false);
            Date date = format.parse(dateStr);
            return date.getTime();
        }
        catch (Exception e) {
            return 0L;
        }
    }
}

