/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.entity.analyze;

import com.huawei.ism.tool.base.utils.AESEncrypt;
import com.huawei.ism.tool.base.utils.PatchUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.loganalyzer.entity.analyze.PythonRule;
import com.huawei.ism.tool.loganalyzer.entity.analyze.ReportLog;
import com.huawei.ism.tool.loganalyzer.entity.log.LogDeCompressDir;
import com.huawei.ism.tool.loganalyzer.exception.AnalyzingFailedException;
import com.huawei.ism.tool.loganalyzer.exception.AnalyzingStopedException;
import com.huawei.ism.tool.loganalyzer.exception.DeCompressFailedException;
import com.huawei.ism.tool.loganalyzer.exception.StopImportException;
import com.huawei.ism.tool.loganalyzer.faulttree.command.model.DateInfo;
import com.huawei.ism.tool.loganalyzer.faulttree.model.DeviceType;
import com.huawei.ism.tool.loganalyzer.faulttree.model.SearchProgress;
import com.huawei.ism.tool.loganalyzer.faulttree.rulesearch.model.CauseMatchResult;
import com.huawei.ism.tool.loganalyzer.faulttree.versionsearch.ProductInfo;
import com.huawei.ism.tool.loganalyzer.monitor.AutoAnalyzeSwicth;
import com.huawei.ism.tool.loganalyzer.util.SearcherUtils;
import com.huawei.ism.tool.loganalyzer.worktaker.callback.ILogListener;
import com.huawei.ism.ui.swing.table.TableRow;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListModel;
import org.slf4j.Logger;

public class LogRow {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(LogRow.class);
    private Long logID;
    private ProductInfo productInfo;
    private File logFile;
    private SearchProgress searchProgress;
    private DeviceType deviceType;
    private Map<String, CauseMatchResult> causeMatchResultMap = new HashMap<String, CauseMatchResult>();
    private String stauts;
    private boolean typeGetByCell;
    private DefaultListModel listModel;
    private TableRow row;
    private int selectRow;
    private List<TableRow> detailList = new ArrayList<TableRow>();
    private String reportTmpFile;
    private List<ReportLog> faultTreeCauseLogs = new ArrayList<ReportLog>();
    private List<ReportLog> alarmInfoLogs = new ArrayList<ReportLog>();
    private List<ReportLog> diagnoseInfoLogs = new ArrayList<ReportLog>();
    private String password;
    private boolean testDecrypt = false;
    private boolean datecollect = false;
    private double messageSize;
    private double timeLogSize;
    private String packageStartTime;
    private String packageEndTime;
    private List<PythonRule> pythonRules;
    private boolean stop = false;
    private boolean stopImpot = false;
    private boolean isNeedWait;
    private ILogListener listener;
    private String indexDir;
    private boolean attempt = false;
    private long analyzeStartTime;
    private long analyzeEndTime;
    private LogDeCompressDir logDeCompressDir;
    private List<String> ctrlNames;

    public LogRow() {
        this.logID = System.currentTimeMillis();
    }

    public List<String> getCtrlNames() {
        return this.ctrlNames;
    }

    public void setCtrlNames(List<String> ctrlNames) {
        this.ctrlNames = ctrlNames;
    }

    public LogDeCompressDir getLogDeCompressDir() {
        return this.logDeCompressDir;
    }

    public void setLogDeCompressDir(LogDeCompressDir logDeCompressDir) {
        this.logDeCompressDir = logDeCompressDir;
    }

    public String getIndexDir() {
        return this.indexDir;
    }

    public void setIndexDir(String indexDir) {
        this.indexDir = indexDir;
    }

    public TableRow getRow() {
        return this.row;
    }

    public void setRow(TableRow row) {
        this.row = row;
    }

    public synchronized File getLogFile() {
        return this.logFile;
    }

    public synchronized void setLogFile(File logFile) {
        this.logFile = logFile;
    }

    public String getType() {
        return this.row.getValueAt(1).toString().trim();
    }

    public String getStauts() {
        return this.stauts;
    }

    public void setStauts(String stauts) {
        this.stauts = stauts;
    }

    public boolean isTypeGetByCell() {
        return this.typeGetByCell;
    }

    public void setTypeGetByCell(boolean typeGetByCell) {
        this.typeGetByCell = typeGetByCell;
    }

    public DefaultListModel<?> getListModel() {
        return this.listModel;
    }

    public void setListModel(DefaultListModel<?> listModel) {
        this.listModel = listModel;
    }

    public List<TableRow> getDetailList() {
        return this.detailList;
    }

    public String getReportTmpFile() {
        return this.reportTmpFile;
    }

    public void setReportTmpFile(String reportTmpFile) {
        this.reportTmpFile = reportTmpFile;
    }

    public int getSelectRow() {
        return this.selectRow;
    }

    public void setSelectRow(int selectRow) {
        this.selectRow = selectRow;
    }

    public String getPassword() {
        if (StringUtils.isNULLStr((String)this.password)) {
            return "";
        }
        return AESEncrypt.decrypt((String)this.password, (String)PatchUtil.importAESPk());
    }

    public void setPassword(String password) {
        this.password = AESEncrypt.encrypt((String)password, (String)PatchUtil.importAESPk());
    }

    public boolean isDatecollect() {
        return this.datecollect;
    }

    public void setDatecollect(boolean datecollect) {
        this.datecollect = datecollect;
    }

    public boolean isTestDecrypt() {
        return this.testDecrypt;
    }

    public void setTestDecrypt(boolean testDecrypt) {
        this.testDecrypt = testDecrypt;
    }

    public String getVersion() {
        return this.row.getValueAt(2).toString();
    }

    public String getVersionWithoutSPC() {
        return this.row.getValueAt(2).toString().split("SPC")[0];
    }

    public double getMessageSize() {
        return this.messageSize;
    }

    public void setMessageSize(double messageSize) {
        this.messageSize = messageSize;
    }

    public String getPackageStartTime() {
        return this.packageStartTime;
    }

    public void setPackageStartTime(String packageStartTime) {
        this.packageStartTime = packageStartTime;
    }

    public String getPackageEndTime() {
        return this.packageEndTime;
    }

    public void setPackageEndTime(String packageEndTime) {
        this.packageEndTime = packageEndTime;
    }

    public List<PythonRule> getPythonRules() {
        return this.pythonRules;
    }

    public void setPythonRules(List<PythonRule> pythonRules) {
        this.pythonRules = pythonRules;
    }

    public synchronized boolean isStop() {
        return this.stop;
    }

    public synchronized void setStop(boolean stop) {
        this.stop = stop;
    }

    public synchronized void analyzeInterruptedFromStopCommand() {
        if (this.stop) {
            LOGGER.info("The name of the Stop thread is : " + Thread.currentThread().getName());
            throw new AnalyzingStopedException("Stop analyzing of the log package[" + this.logFile.getName() + "] successfully.");
        }
    }

    public synchronized void analyzeInterruptedFromAnError(String errorSourceID) {
        AnalyzingFailedException e = new AnalyzingFailedException("Failed analyzing of the log package[" + this.logFile.getName() + "]");
        e.setErrorSourceID(errorSourceID);
        throw e;
    }

    public synchronized void analyzeInterruptedFromAnError(String errorSourceID, Throwable se) {
        AnalyzingFailedException e = new AnalyzingFailedException("Failed analyzing of the log package[" + this.logFile.getName() + "]", se);
        e.setErrorSourceID(errorSourceID);
        throw e;
    }

    public synchronized void stopImportAnClick() {
        if (this.isStopImpot()) {
            LOGGER.info("The name of the Stop thread is : " + Thread.currentThread().getName());
            throw new StopImportException("stop import[" + this.logFile.getName() + "] successfully.");
        }
    }

    public synchronized void deCompressFailed() {
        LOGGER.info("The name of the Stop thread is : " + Thread.currentThread().getName());
        throw new DeCompressFailedException("decompress failed[" + this.logFile.getName() + "] successfully.");
    }

    public void clearCache() {
        this.setListModel(new DefaultListModel());
        this.faultTreeCauseLogs.clear();
        this.alarmInfoLogs.clear();
        this.diagnoseInfoLogs.clear();
        this.detailList.clear();
        this.setStop(false);
    }

    public void clearLogFaultTree() {
        this.causeMatchResultMap.clear();
    }

    public void clearAllCache() {
        this.clearCache();
    }

    public boolean isResultNotEmpty() {
        boolean causeMatchResult = false;
        boolean eventResult = false;
        boolean diagnoseResult = false;
        boolean logConfigResult = false;
        return causeMatchResult || eventResult || diagnoseResult || logConfigResult;
    }

    public boolean isStopImpot() {
        if (AutoAnalyzeSwicth.isStop()) {
            return true;
        }
        return this.stopImpot;
    }

    public void setStopImpot(boolean stopImpot) {
        this.stopImpot = stopImpot;
    }

    public ILogListener getListener() {
        return this.listener;
    }

    public void setListener(ILogListener listener) {
        this.listener = listener;
    }

    public boolean isAttempt() {
        return this.attempt;
    }

    public void setAttempt(boolean attempt) {
        this.attempt = attempt;
    }

    public double getTimeLogSize() {
        return this.timeLogSize;
    }

    public void setTimeLogSize(double timeLogSize) {
        this.timeLogSize = timeLogSize;
    }

    public List<ReportLog> getFaultTreeCauseLogs() {
        return this.faultTreeCauseLogs;
    }

    public void setAnalyzeStartTime(long analyzeStartTime) {
        this.analyzeStartTime = analyzeStartTime;
    }

    public void setAnalyzeEndTime(long analyzeEndTime) {
        this.analyzeEndTime = analyzeEndTime;
    }

    public long getAnalyzeSpendTime() {
        return this.analyzeEndTime - this.analyzeStartTime;
    }

    public void addKnownRiskLogs(ReportLog log) {
        this.faultTreeCauseLogs.add(log);
    }

    public List<ReportLog> getAlarmInfoLogs() {
        return this.alarmInfoLogs;
    }

    public void addAlarmInfoLogs(ReportLog log) {
        this.alarmInfoLogs.add(log);
    }

    public List<ReportLog> getDiagnoseInfoLogs() {
        return this.diagnoseInfoLogs;
    }

    public void addDiagnoseInfoLogs(ReportLog log) {
        this.diagnoseInfoLogs.add(log);
    }

    public synchronized void waitStopThreadFinish() {
        try {
            if (this.isNeedWait) {
                int i = 0;
                while (i < 1) {
                    this.wait(3000L);
                    ++i;
                }
            }
        }
        catch (InterruptedException e) {
            LOGGER.error("waitStopThreadFinish occor an InterruptedException", (Object)e.toString());
        }
    }

    public synchronized void notifyAnalysisThread() {
        if (this.isNeedWait) {
            this.notifyAll();
        }
    }

    public synchronized void setNeedWait(boolean ifNeedWait) {
        this.isNeedWait = ifNeedWait;
    }

    public ProductInfo getProductInfo() {
        return this.productInfo;
    }

    public void setProductInfo(ProductInfo productInfo) {
        this.productInfo = productInfo;
    }

    public DeviceType getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(DeviceType deviceType) {
        this.deviceType = deviceType;
    }

    public Map<String, CauseMatchResult> getCauseMatchResultMap() {
        return this.causeMatchResultMap;
    }

    public void setCauseMatchResultMap(Map<String, CauseMatchResult> causeMatchResultMap) {
        this.causeMatchResultMap = causeMatchResultMap;
    }

    public SearchProgress getSearchProgress() {
        return this.searchProgress;
    }

    public void setSearchProgress(SearchProgress searchProgress) {
        this.searchProgress = searchProgress;
    }

    public Map<String, CauseMatchResult> getFilterCauseMatchResultMap() {
        HashMap<String, CauseMatchResult> result = new HashMap<String, CauseMatchResult>();
        if (this.causeMatchResultMap == null) {
            return result;
        }
        for (Map.Entry<String, CauseMatchResult> entry : this.causeMatchResultMap.entrySet()) {
            DateInfo di = entry.getValue().getDateInfo();
            if (di != null && !SearcherUtils.isOnSetDate(di.getTime())) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public Long getLogID() {
        return this.logID;
    }

    public void setLogID(Long logID) {
        this.logID = logID;
    }
}

