/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.entity.execresult;

import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.loganalyzer.entity.execresult.ExecuteResult;
import com.huawei.ism.tool.loganalyzer.util.LoganalyzerContext;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class DetailListCellRenderer
extends DefaultListCellRenderer {
    private static final long serialVersionUID = 1L;
    private static final int DATE_LENGTH = 150;
    private static final int DEC_LENGTH = 600;
    private static final int SHOW_HEIGHT = 18;

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Color bg = null;
        JList.DropLocation dropLocation = list.getDropLocation();
        if (dropLocation != null && dropLocation.isInsert() && dropLocation.getIndex() == index) {
            bg = UIManager.getColor("List.dropCellBackground");
            isSelected = true;
        }
        JPanel viewPanel = new JPanel();
        if (value instanceof ExecuteResult) {
            ExecuteResult result = (ExecuteResult)value;
            JLabel dateLabel = new JLabel("  " + result.getStartDateString());
            UiMethod.setComponentSize((Dimension)new Dimension(150, 18), (Component[])new Component[]{dateLabel});
            JLabel decLabel = new JLabel(result.getDescription());
            UiMethod.setComponentSize((Dimension)new Dimension(600, 18), (Component[])new Component[]{decLabel});
            JLabel progressLabel = new JLabel("");
            if (result.getProgress() == 0) {
                progressLabel.setIcon(LoganalyzerContext.LOADING_IMAGE);
            } else if (100 == result.getProgress()) {
                progressLabel.setIcon(LoganalyzerContext.SUCCESS_IMAGE);
            } else {
                progressLabel.setIcon(LoganalyzerContext.FAIL_IMAGE);
            }
            JComponent view = UCD.buildHorizotalBox(null, (int)0, (Component[])new Component[]{dateLabel, decLabel, Box.createHorizontalGlue(), progressLabel, Box.createHorizontalStrut(8)});
            viewPanel.setLayout(new BorderLayout());
            viewPanel.add((Component)view, "Center");
            viewPanel.setToolTipText(result.getDescription());
        }
        viewPanel.setComponentOrientation(list.getComponentOrientation());
        viewPanel.setEnabled(list.isEnabled());
        viewPanel.setFont(list.getFont());
        if (isSelected) {
            viewPanel.setBackground(bg == null ? list.getSelectionBackground() : bg);
            UiMethod.setBatchComponentProperty((String)"setForeground", (Object[])new Object[]{Color.WHITE}, (JComponent[])new JComponent[]{viewPanel});
        } else {
            viewPanel.setBackground(list.getBackground());
            viewPanel.setForeground(list.getBackground());
        }
        return viewPanel;
    }
}

