/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.entity.execresult;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ExecuteResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Date executeTime = new Date();
    private String description = null;
    private int progress = 0;
    private Boolean result = null;
    private String packName = null;

    public ExecuteResult() {
    }

    public ExecuteResult(String description, int progress, Boolean result) {
        this();
        this.description = description;
        this.result = result;
        this.progress = progress;
        this.adjustProgress();
    }

    public boolean isProcessing() {
        return this.result == null;
    }

    private void adjustProgress() {
        if (this.result != null && !this.result.booleanValue()) {
            this.progress = 100;
        }
    }

    public Date getExecuteTime() {
        return (Date)this.executeTime.clone();
    }

    public String getStartDateString() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(this.executeTime);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setResult(Boolean result) {
        this.result = result;
        this.adjustProgress();
    }

    public boolean isSuccess() {
        if (this.result != null) {
            return this.result;
        }
        return true;
    }

    public void setProgress(int progress) {
        this.progress = progress;
        this.adjustProgress();
    }

    public int getProgress() {
        return this.progress;
    }

    public String toString() {
        return this.description;
    }

    public void setExecuteTime(Date executeTime) {
        this.executeTime = (Date)executeTime.clone();
    }

    public String getPackName() {
        return this.packName;
    }

    public void setPackName(String packName) {
        this.packName = packName;
    }
}

