/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.entity.execresult;

import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.loganalyzer.entity.analyze.SearchResult;
import com.huawei.ism.tool.loganalyzer.util.ConfigInfoConstant;
import com.huawei.ism.tool.loganalyzer.util.SearcherUtils;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public class SearchResultListCellRender
extends DefaultListCellRenderer {
    private static final long serialVersionUID = 1L;
    private static final int ORIGINAL_LENGTH = 1485;
    private static final int SHOW_HEIGHT = 18;

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JList.DropLocation dropLocation = list.getDropLocation();
        Color bg = null;
        if (dropLocation != null && dropLocation.isInsert() && dropLocation.getIndex() == index) {
            bg = UIManager.getColor("List.dropCellBackground");
            isSelected = true;
        }
        Color color = bg == null ? list.getSelectionBackground() : bg;
        JPanel viewPanel = new JPanel();
        JTextArea area = new JTextArea();
        if (value instanceof SearchResult) {
            SearchResult result = (SearchResult)value;
            if (StringUtils.isNULLStr((String)result.getMessage())) {
                UiMethod.setComponentSize((Dimension)new Dimension(1485, 18), (Component[])new Component[]{area});
                StringBuilder line = new StringBuilder();
                line.append(result.getOriginal());
                area.setText(line.toString());
                JLabel fileName = new JLabel(result.getFile().getName());
                int with = result.getFile().length() > 10L ? 180 : 55;
                UiMethod.setComponentSize((Dimension)new Dimension(with, 18), (Component[])new Component[]{fileName});
                StringBuilder logLineStr = new StringBuilder();
                logLineStr.append(" Line " + this.formatLine(String.valueOf(result.getLogLine())) + ":");
                JLabel logLine = new JLabel(logLineStr.toString());
                logLine.setFont(ConfigInfoConstant.COURIER_NEW_FONT);
                UiMethod.setComponentSize((Dimension)new Dimension(80, 18), (Component[])new Component[]{logLine});
                List<String> keyWords = result.getKeywordsList();
                if (keyWords != null) {
                    for (String keyWord : keyWords) {
                        SearcherUtils.addHighlight(area, keyWord.trim(), Color.GREEN);
                    }
                }
                JComponent view = UCD.buildHorizotalBox(null, (int)0, (Component[])new Component[]{fileName, logLine, area});
                viewPanel.setLayout(new BorderLayout());
                viewPanel.add((Component)view, "Center");
            } else {
                JLabel messageLabel = new JLabel(result.getMessage(), 0);
                viewPanel.add((Component)messageLabel, "Center");
            }
        }
        viewPanel.setComponentOrientation(list.getComponentOrientation());
        viewPanel.setEnabled(list.isEnabled());
        viewPanel.setFont(list.getFont());
        if (isSelected) {
            viewPanel.setBackground(color);
            area.setBackground(color);
            UiMethod.setBatchComponentProperty((String)"setForeground", (Object[])new Object[]{Color.WHITE}, (JComponent[])new JComponent[]{viewPanel});
        } else {
            viewPanel.setBackground(list.getBackground());
            viewPanel.setForeground(list.getBackground());
        }
        return viewPanel;
    }

    private String formatLine(String logLine) {
        if (logLine != null) {
            String result = logLine;
            int i = 0;
            while (i < 6 - logLine.length()) {
                result = " " + result;
                ++i;
            }
            return result;
        }
        return "";
    }
}

