/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.entity.log;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.loganalyzer.entity.config.SingleLogSearchRule;
import com.huawei.ism.tool.loganalyzer.faulttree.util.FileUtil;
import java.io.File;

public class Log
implements Comparable<Log> {
    private String date;
    private String startOperationDate;
    private String desc;
    private String logPath;
    private String id;
    private String recoveredLocalTime;
    private String jiffies;
    private String level;
    private String sequence;
    private SingleLogSearchRule matchedSearchRule;
    private String module;
    private String originalStr;
    private String others;
    private int line;
    private int type = 3;
    private String pId;

    public Log() {
    }

    public Log(File file, String ... strings) {
        this.logPath = FileUtil.getFilePath(file);
        this.id = strings[0];
        this.date = strings[1];
        this.level = strings[2];
        this.module = strings[3];
        this.jiffies = strings[4];
        this.others = strings[5];
        this.desc = strings[6];
    }

    public Log(String ... strings) {
        this.id = strings[0];
        this.date = strings[1];
        this.level = strings[2];
        this.module = strings[3];
        this.jiffies = strings[4];
        this.others = strings[5];
        this.desc = strings[6];
    }

    public boolean after(Log another) {
        String otherDate;
        String curData = this.tanDate(this.date);
        int ret = curData.compareToIgnoreCase(otherDate = this.tanDate(another.date));
        if (ret == 0) {
            return this.getLine() > another.getLine();
        }
        return ret > 0;
    }

    public String getStartOperationDate() {
        return this.startOperationDate;
    }

    public void setStartOperationDate(String startOperationDate) {
        this.startOperationDate = startOperationDate;
    }

    public String getDate() {
        return this.date;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getId() {
        return this.id;
    }

    public String getJiffies() {
        return this.jiffies;
    }

    public String getRecoveredLocalTime() {
        return this.recoveredLocalTime;
    }

    public void setRecoveredLocalTime(String recoveredTime) {
        this.recoveredLocalTime = recoveredTime;
    }

    public String getLevel() {
        return this.level;
    }

    public SingleLogSearchRule getMatchedSearchRule() {
        return this.matchedSearchRule;
    }

    public String getModule() {
        return this.module;
    }

    public String getOriginalStr() {
        if (this.originalStr != null) {
            this.originalStr = this.originalStr.replaceAll(">", "&gt;");
            this.originalStr = this.originalStr.replaceAll("<", "&lt;");
        }
        return this.originalStr;
    }

    public String getOthers() {
        return this.others;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setJiffies(String jiffies) {
        this.jiffies = jiffies;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public void setSequence(String sequence) {
        this.sequence = sequence == null ? "--" : sequence;
    }

    public String getSequence() {
        return this.sequence == null ? "--" : this.sequence;
    }

    public void setMatchedSearchRule(SingleLogSearchRule matchedSearchRule) {
        this.matchedSearchRule = matchedSearchRule;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public void setOriginalStr(String originalStr) {
        this.originalStr = originalStr;
    }

    public void setOthers(String others) {
        this.others = others;
    }

    public String toString() {
        return new StringBuffer().append(this.date).append(this.jiffies).append(this.id).append(this.level).append(this.desc).append(this.module).append(this.others).toString();
    }

    private String tanDate(String curDate) {
        String retString = "0";
        if (StringUtils.hasMatchStr((String)curDate, (String)"(\\d{4}-[0-1]\\d-[0-3]\\d [0-5]\\d:[0-5]\\d:[0-5]\\d)")) {
            retString = StringUtils.findMatchStr((String)curDate, (String)"(\\d{4}-[0-1]\\d-[0-3]\\d [0-5]\\d:[0-5]\\d:[0-5]\\d)");
        }
        if (StringUtils.hasMatchStr((String)curDate, (String)"(\\d{4}-[0-1]\\d-[0-3]\\d [0-5]\\d:[0-5]\\d:[0-5]\\d\\.\\d{3})")) {
            retString = StringUtils.findMatchStr((String)curDate, (String)"(\\d{4}-[0-1]\\d-[0-3]\\d [0-5]\\d:[0-5]\\d:[0-5]\\d\\.\\d{3})");
        }
        return retString;
    }

    @Override
    public int compareTo(Log o) {
        String otherDate;
        String curData = this.tanDate(this.date);
        int ret = curData.compareToIgnoreCase(otherDate = this.tanDate(o.getDate()));
        if (ret == 0) {
            return this.getLine() - o.getLine();
        }
        return ret;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getpId() {
        return this.pId;
    }

    public void setpId(String pIdNo) {
        this.pId = pIdNo;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Log other = (Log)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String getLogPath() {
        return this.logPath;
    }

    public void setLogPath(String logPath) {
        this.logPath = logPath;
    }
}

