/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.faulttree.command.diagnose;

import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.loganalyzer.faulttree.command.diagnose.KeyValueCompare;
import com.huawei.ism.tool.loganalyzer.faulttree.command.templet.DiagnoseCommand;
import com.huawei.ism.tool.loganalyzer.faulttree.exception.DiagnoseCommandExecuteException;
import com.huawei.ism.tool.loganalyzer.faulttree.rulesearch.model.RecordInfo;
import com.huawei.ism.tool.loganalyzer.faulttree.util.IOUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.StringReader;
import java.util.Vector;
import org.slf4j.Logger;

public class BBUBuckCheck
extends DiagnoseCommand {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(KeyValueCompare.class);
    private boolean matcher = false;

    @Override
    public void diagnose(Vector<RecordInfo> v) {
        StringReader sr = null;
        BufferedReader br = null;
        String content = null;
        int count = 0;
        for (RecordInfo recordInfo : v) {
            block6: {
                try {
                    try {
                        content = recordInfo.getContent().toString();
                        sr = new StringReader(content);
                        br = new BufferedReader(sr);
                        count = this.matchNumber(br, count);
                    }
                    catch (IOException e) {
                        LOGGER.info("already catch IOException" + e);
                        IOUtils.close((Closeable)sr);
                        IOUtils.close((Closeable)br);
                        break block6;
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.close(sr);
                    IOUtils.close(br);
                    throw throwable;
                }
                IOUtils.close((Closeable)sr);
                IOUtils.close((Closeable)br);
            }
            if (count != 0) continue;
            throw new DiagnoseCommandExecuteException("BBUBuckCheck Failed!");
        }
    }

    private int matchNumber(BufferedReader br, int count) throws IOException {
        String lineContent;
        while ((lineContent = br.readLine()) != null) {
            String[] keyValues;
            if (!lineContent.trim().startsWith("BBU 0 output voltage") && !lineContent.trim().startsWith("BBU 1 output voltage") || (keyValues = lineContent.trim().split(":")).length <= 1) continue;
            this.matcher = this.doDiagnose(keyValues[1].trim());
            if (!this.matcher) continue;
            ++count;
        }
        return count;
    }

    private boolean doDiagnose(String br) {
        float value = Float.valueOf(br.substring(0, br.indexOf("v")).trim()).floatValue();
        return (double)value < 10.0;
    }
}

