/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.faulttree.command.diagnose;

import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.loganalyzer.faulttree.command.diagnose.KeyValueCompare;
import com.huawei.ism.tool.loganalyzer.faulttree.command.templet.DiagnoseCommand;
import com.huawei.ism.tool.loganalyzer.faulttree.exception.DiagnoseCommandExecuteException;
import com.huawei.ism.tool.loganalyzer.faulttree.rulesearch.model.RecordInfo;
import com.huawei.ism.tool.loganalyzer.faulttree.util.IOUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.StringReader;
import java.util.Vector;
import org.slf4j.Logger;

public class BBUCoreCheck
extends DiagnoseCommand {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(KeyValueCompare.class);
    private static final Double NUMBER2POINT4 = 2.4;
    private static final Double NUMBER3POINT6 = 3.6;
    private boolean matcher = false;

    @Override
    public void diagnose(Vector<RecordInfo> v) {
        StringReader sr = null;
        BufferedReader br = null;
        String content = null;
        int count = 0;
        for (RecordInfo recordInfo : v) {
            try {
                try {
                    content = recordInfo.getContent().toString();
                    sr = new StringReader(content);
                    br = new BufferedReader(sr);
                    count = this.matchNumber(br, count);
                }
                catch (IOException e) {
                    LOGGER.info("already catch IOException" + e);
                    IOUtils.close((Closeable)sr);
                    IOUtils.close((Closeable)br);
                    continue;
                }
            }
            catch (Throwable throwable) {
                IOUtils.close(sr);
                IOUtils.close(br);
                throw throwable;
            }
            IOUtils.close((Closeable)sr);
            IOUtils.close((Closeable)br);
        }
        if (count == 0) {
            throw new DiagnoseCommandExecuteException("BBUCoreCheck Failed!");
        }
    }

    private int matchNumber(BufferedReader br, int count) throws IOException {
        String lineContent;
        while ((lineContent = br.readLine()) != null) {
            if (!lineContent.trim().startsWith("BBU 0 core voltage") && !lineContent.trim().startsWith("BBU 1 core voltage")) continue;
            count = this.lineDiagnose(count, lineContent);
        }
        return count;
    }

    private int lineDiagnose(int count, String lineContent) {
        String[] keyValues = lineContent.trim().split(":");
        if (keyValues.length > 1 && keyValues[1].trim().length() > 1) {
            String[] values = keyValues[1].trim().split("  ");
            int i = 0;
            while (i < values.length) {
                this.matcher = this.doDiagnose(values[i]);
                if (!this.matcher) {
                    ++count;
                }
                ++i;
            }
        }
        return count;
    }

    private boolean doDiagnose(String br) {
        if (br != null && !br.equals(" ")) {
            float value = Float.valueOf(br.substring(0, br.indexOf("v")).trim()).floatValue();
            if (NUMBER2POINT4 <= (double)value && (double)value <= NUMBER3POINT6) {
                return true;
            }
        }
        return false;
    }
}

