/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.faulttree.command.diagnose;

import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.loganalyzer.faulttree.command.templet.DiagnoseCommand;
import com.huawei.ism.tool.loganalyzer.faulttree.exception.DiagnoseCommandExecuteException;
import com.huawei.ism.tool.loganalyzer.faulttree.rulesearch.model.RecordInfo;
import com.huawei.ism.tool.loganalyzer.faulttree.util.IOUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.StringReader;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;

public class BoardVoltageCheck
extends DiagnoseCommand {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(BoardVoltageCheck.class);
    private static final Pattern COLON_SPLITOR = Pattern.compile(":");
    private static final Pattern SPACES_SPLITOR = Pattern.compile("\\s+");
    private static final Pattern STAR_SPLITOR = Pattern.compile("\\*+");

    @Override
    public void diagnose(Vector<RecordInfo> v) {
        StringReader sr = null;
        BufferedReader br = null;
        String content = null;
        int matchedCount = 0;
        for (RecordInfo recordInfo : v) {
            try {
                content = recordInfo.getContent().toString();
                sr = new StringReader(content);
                br = new BufferedReader(sr);
                matchedCount += this.doDiagnose(br);
            }
            catch (IOException e) {
                LOGGER.info("already catch IOException" + e);
                IOUtils.close((Closeable)sr);
                IOUtils.close((Closeable)br);
                continue;
            }
            catch (NumberFormatException e1) {
                try {
                    LOGGER.info("already catch IOException" + e1);
                }
                catch (Throwable throwable) {
                    IOUtils.close(sr);
                    IOUtils.close(br);
                    throw throwable;
                }
                IOUtils.close((Closeable)sr);
                IOUtils.close((Closeable)br);
                continue;
            }
            IOUtils.close((Closeable)sr);
            IOUtils.close((Closeable)br);
        }
        if (matchedCount < 1) {
            throw new DiagnoseCommandExecuteException("Match Failed!");
        }
    }

    private int doDiagnose(BufferedReader br) throws NumberFormatException, IOException {
        String lineContent;
        int matchedCount = 0;
        while ((lineContent = br.readLine()) != null) {
            String[] numbers;
            String[] keyValues;
            Matcher matcher = STAR_SPLITOR.matcher(lineContent);
            if (matcher.find() || !(keyValues = COLON_SPLITOR.split(lineContent))[0].trim().equals("board voltage alarm") || keyValues[1].equals("") || Integer.parseInt((numbers = SPACES_SPLITOR.split(keyValues[1].trim()))[numbers.length - 1]) != 1) continue;
            ++matchedCount;
        }
        return matchedCount;
    }
}

