/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.faulttree.command.diagnose;

import com.huawei.ism.tool.loganalyzer.faulttree.command.templet.DiagnoseCommand;
import com.huawei.ism.tool.loganalyzer.faulttree.exception.DiagnoseCommandExecuteException;
import com.huawei.ism.tool.loganalyzer.faulttree.rulesearch.model.RecordInfo;
import com.huawei.ism.tool.loganalyzer.faulttree.util.MatcherUtils;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HostSystemConfigCheck
extends DiagnoseCommand {
    private static final Pattern FILENAME = Pattern.compile("messages_\\d{8}_*\\d{6}");
    private static final Pattern TIMEPATTERN = Pattern.compile("\\d{8}_*\\d{6}");

    @Override
    public void diagnose(Vector<RecordInfo> v) {
        block4: {
            try {
                int count = 0;
                Vector<RecordInfo> v1 = new Vector<RecordInfo>();
                for (RecordInfo reInfo : v) {
                    long fileTime;
                    File file = new File(reInfo.getFilePath());
                    Matcher matcher = MatcherUtils.match(file.getName().toString(), FILENAME);
                    if (matcher == null) continue;
                    long reInfoTime = reInfo.getDateInfo().getTime();
                    String timeStr = matcher.group();
                    Matcher timePatternMat = MatcherUtils.match(timeStr, TIMEPATTERN);
                    if (timePatternMat == null || Math.abs(reInfoTime - (fileTime = HostSystemConfigCheck.parseFileTime(timeStr = timePatternMat.group().replace("_", "")).getTime())) / 1000L >= 86400L) continue;
                    ++count;
                    v1.add(reInfo);
                }
                if (count != 0) {
                    v.removeAllElements();
                    v.addAll(v1);
                    break block4;
                }
                throw new DiagnoseCommandExecuteException();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new DiagnoseCommandExecuteException();
            }
        }
    }

    private static Date parseFileTime(String string) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        Date date = null;
        try {
            date = sdf.parse(string);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }
}

