/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.faulttree.command.diagnose;

import com.huawei.ism.tool.loganalyzer.faulttree.command.enumer.RuleOperator;
import com.huawei.ism.tool.loganalyzer.faulttree.command.templet.DiagnoseCommand;
import com.huawei.ism.tool.loganalyzer.faulttree.exception.DiagnoseCommandExecuteException;
import com.huawei.ism.tool.loganalyzer.faulttree.rulesearch.model.RecordInfo;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;

public class IntegerCompare
extends DiagnoseCommand {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(IntegerCompare.class);
    private List<Regex> regexList = new ArrayList<Regex>();
    private RuleOperator operator = RuleOperator.GT;
    private int from = 0;
    private int to = 0;
    private boolean isBinary = false;
    private String compareValue;

    public IntegerCompare(RuleOperator operator, String compareValue, boolean isBinary, String from, String to) {
        if (operator != null) {
            this.operator = operator;
        }
        if (isBinary) {
            this.isBinary = isBinary;
        }
        this.compareValue = compareValue;
        if (from != null && to != null) {
            this.from = Integer.parseInt(from);
            this.to = Integer.parseInt(to);
        }
    }

    public void add(String value, int index) {
        Regex r = new Regex();
        r.initRegex(value, index);
        this.regexList.add(r);
    }

    @Override
    public void diagnose(Vector<RecordInfo> v) {
        for (RecordInfo recordInfo : v) {
            try {
                boolean matchedCount = this.doDiagnose(recordInfo.getContent());
                if (matchedCount) continue;
                throw new DiagnoseCommandExecuteException("Match failed!");
            }
            catch (IOException e) {
                LOGGER.info("already catch IOException" + e);
            }
        }
    }

    public boolean doDiagnose(CharSequence charSequence) throws IOException {
        List<CharSequence> contentList = new ArrayList<CharSequence>();
        boolean isSuccess = false;
        contentList.add(charSequence);
        try {
            for (Regex regex : this.regexList) {
                contentList = this.getAllMatchStr(contentList, regex);
            }
            Regex lastRegex = this.regexList.get(this.regexList.size() - 1);
            int index = lastRegex.getIndex() - 1;
            if (contentList.size() > index) {
                isSuccess = this.dealOperator(contentList, index);
            }
        }
        catch (Exception e) {
            isSuccess = false;
            LOGGER.info("Diganose integer error:" + e);
        }
        return isSuccess;
    }

    private boolean dealOperator(List<CharSequence> contentList, int index) {
        boolean isSuccess = false;
        if (index >= 0) {
            isSuccess = this.operator.isSuccess(this.getCompareStr(contentList.get(index).toString()), this.compareValue, this.from, this.to);
        } else {
            for (CharSequence str : contentList) {
                isSuccess = this.operator.isSuccess(this.getCompareStr(str.toString()), this.compareValue, this.from, this.to);
                if (isSuccess) break;
            }
        }
        return isSuccess;
    }

    private String getCompareStr(String str) {
        if (this.isBinary) {
            if (str.toLowerCase(Locale.ENGLISH).startsWith("0x")) {
                str = str.replace("0x", "");
            }
            return String.valueOf(Integer.parseInt(str, 16));
        }
        return str;
    }

    private List<CharSequence> getAllMatchStr(List<CharSequence> contentList, Regex regex) {
        ArrayList<CharSequence> curList = new ArrayList<CharSequence>();
        for (CharSequence str : contentList) {
            Matcher matcher = regex.getValuePattern().matcher(str);
            int index = regex.getIndex();
            int count = 0;
            while (matcher.find()) {
                if (index != 0 && index != ++count) continue;
                curList.add(matcher.group());
            }
        }
        return curList;
    }

    public static final class Regex {
        private Pattern valuePattern;
        private int index;

        public void initRegex(String value, int inde) {
            this.valuePattern = Pattern.compile(value);
            this.index = inde;
        }

        public Pattern getValuePattern() {
            return this.valuePattern;
        }

        public void setValuePattern(Pattern valuePattern) {
            this.valuePattern = valuePattern;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

