/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.faulttree.command.diagnose;

import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.loganalyzer.faulttree.command.enumer.RuleOperator;
import com.huawei.ism.tool.loganalyzer.faulttree.command.templet.DiagnoseCommand;
import com.huawei.ism.tool.loganalyzer.faulttree.exception.DiagnoseCommandExecuteException;
import com.huawei.ism.tool.loganalyzer.faulttree.rulesearch.model.RecordInfo;
import com.huawei.ism.tool.loganalyzer.faulttree.util.IOUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.StringReader;
import java.util.Vector;
import java.util.regex.Pattern;
import org.slf4j.Logger;

public class KeyValueCompare
extends DiagnoseCommand {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(KeyValueCompare.class);
    private static final Pattern KEY_VALUE_SPLITOR = Pattern.compile("(:|=|\\|)");
    private RuleOperator operator = RuleOperator.IN;
    private String key;
    private String value;
    private int from;
    private int to;

    public KeyValueCompare(RuleOperator operator, String key, String value, int from, int to) {
        if (operator != null) {
            this.operator = operator;
        }
        this.key = key;
        this.value = value;
        this.from = from;
        this.to = to;
    }

    @Override
    public void diagnose(Vector<RecordInfo> v) {
        StringReader sr = null;
        BufferedReader br = null;
        String content = null;
        int matchedCount = 0;
        for (RecordInfo recordInfo : v) {
            try {
                try {
                    content = recordInfo.getContent().toString();
                    sr = new StringReader(content);
                    br = new BufferedReader(sr);
                    br.readLine();
                    matchedCount += this.doDiagnose(br);
                }
                catch (IOException e) {
                    LOGGER.info("already catch IOException" + e);
                    IOUtils.close((Closeable)sr);
                    IOUtils.close((Closeable)br);
                    continue;
                }
            }
            catch (Throwable throwable) {
                IOUtils.close(sr);
                IOUtils.close(br);
                throw throwable;
            }
            IOUtils.close((Closeable)sr);
            IOUtils.close((Closeable)br);
        }
        if (matchedCount == 0) {
            throw new DiagnoseCommandExecuteException("Match Failed!");
        }
    }

    private int doDiagnose(BufferedReader br) throws IOException {
        String lineContent;
        int matchedCount = 0;
        while ((lineContent = br.readLine()) != null) {
            boolean isSuccess;
            String[] keyValues = KEY_VALUE_SPLITOR.split(lineContent);
            if (keyValues.length < 2 || !keyValues[0].trim().equals(this.key) || !(isSuccess = this.operator.isSuccess(keyValues[1].trim(), this.value, this.from, this.to))) continue;
            ++matchedCount;
        }
        return matchedCount;
    }
}

