/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.faulttree.command.diagnose;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.loganalyzer.faulttree.command.enumer.RuleOperator;
import com.huawei.ism.tool.loganalyzer.faulttree.command.templet.DiagnoseCommand;
import com.huawei.ism.tool.loganalyzer.faulttree.exception.DiagnoseCommandExecuteException;
import com.huawei.ism.tool.loganalyzer.faulttree.rulesearch.model.RecordInfo;
import com.huawei.ism.tool.loganalyzer.faulttree.util.IOUtils;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;
import org.slf4j.Logger;

public class KeyValueIterateCompare
extends DiagnoseCommand {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(KeyValueIterateCompare.class);
    private static final Pattern KEY_VALUE_SPLITOR = Pattern.compile("(:|=|\\|)");
    private static final Pattern REGEX_DIVIDING_LINE = Pattern.compile("^[\\-\\s]+$");
    private List<KeyValue> keyValueList = new ArrayList<KeyValue>();

    public void add(String key, String value, int from, int to, RuleOperator operator) {
        this.keyValueList.add(new KeyValue(operator, key, value, from, to));
    }

    @Override
    public void diagnose(Vector<RecordInfo> v) {
        StringReader sr = null;
        BufferedReader br = null;
        String content = null;
        for (RecordInfo recordInfo : v) {
            try {
                try {
                    content = recordInfo.getContent().toString();
                    sr = new StringReader(content);
                    br = new BufferedReader(sr);
                    br.readLine();
                    int matchedCount = this.doDiagnose(br);
                    if (matchedCount == 0) {
                        throw new DiagnoseCommandExecuteException("Don't find the key of original text!");
                    }
                }
                catch (IOException e) {
                    LOGGER.info("already catch IOException" + e);
                    IOUtils.close((Closeable)sr);
                    IOUtils.close((Closeable)br);
                    continue;
                }
            }
            catch (Throwable throwable) {
                IOUtils.close(sr);
                IOUtils.close(br);
                throw throwable;
            }
            IOUtils.close((Closeable)sr);
            IOUtils.close((Closeable)br);
        }
    }

    private String keepLastMaoHao(String lineContent) {
        StringBuffer lineContentBuff = new StringBuffer();
        int count = 0;
        int i = lineContent.length() - 1;
        while (i >= 0) {
            char c = lineContent.charAt(i);
            if (c != ':' || count++ <= 0) {
                lineContentBuff.append(c);
            }
            --i;
        }
        StringBuffer lineContentBuff1 = new StringBuffer();
        int i2 = lineContentBuff.length() - 1;
        while (i2 >= 0) {
            lineContentBuff1.append(lineContentBuff.charAt(i2));
            --i2;
        }
        return lineContentBuff1.toString();
    }

    private int doDiagnose(BufferedReader br) throws IOException {
        String lineContent;
        int matchedCount = 0;
        while ((lineContent = br.readLine()) != null) {
            if (StringUtils.isNULLStr((String)lineContent)) continue;
            String[] keyValues = KEY_VALUE_SPLITOR.split(lineContent = this.keepLastMaoHao(lineContent));
            if (keyValues.length < 2) {
                if (REGEX_DIVIDING_LINE.matcher(lineContent).matches()) break;
                throw new DiagnoseCommandExecuteException("The format of the key-value-content is illegal:" + lineContent);
            }
            for (KeyValue keyValue : this.keyValueList) {
                if (!keyValues[0].trim().contains(keyValue.getKey())) continue;
                boolean isSuccess = keyValue.operator.isSuccess(keyValues[1].trim(), keyValue.getValue(), keyValue.from, keyValue.to);
                if (!isSuccess) {
                    throw new DiagnoseCommandExecuteException("Values do not match.  OriginalValue:  " + keyValues[1].trim() + " ;  CompareValue:  " + keyValue.getValue());
                }
                ++matchedCount;
            }
        }
        return matchedCount;
    }

    public static final class KeyValue {
        private RuleOperator operator = RuleOperator.IN;
        private String key;
        private String value;
        private int from;
        private int to;

        public KeyValue(RuleOperator operator, String key, String value, int from, int to) {
            this.key = key;
            this.value = value;
            this.from = from;
            this.to = to;
            if (operator != null) {
                this.operator = operator;
            }
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public RuleOperator getOperator() {
            return this.operator;
        }

        public int getFrom() {
            return this.from;
        }

        public int getTo() {
            return this.to;
        }

        public String toString() {
            return "KeyValue [operator=" + (Object)((Object)this.operator) + ", key=" + this.key + ", value=" + this.value + ", from=" + this.from + ", to=" + this.to + "]";
        }
    }
}

