/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.faulttree.command.diagnose;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.loganalyzer.faulttree.command.diagnose.TableRowKeyValueColIterateCompare;
import com.huawei.ism.tool.loganalyzer.faulttree.command.templet.DiagnoseCommand;
import com.huawei.ism.tool.loganalyzer.faulttree.exception.DiagnoseCommandExecuteException;
import com.huawei.ism.tool.loganalyzer.faulttree.rulesearch.model.RecordInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Vector;

public class MultiTableRowKeyValueColIterateCompare
extends DiagnoseCommand {
    private static final String LOGIC_OR = "OR";
    private String logic = "and";
    private final List<TableRowKeyValueColIterateCompare> compareList = new ArrayList<TableRowKeyValueColIterateCompare>();

    public MultiTableRowKeyValueColIterateCompare(String logic) {
        if (!StringUtils.isNULLStr((String)logic)) {
            this.logic = logic;
        }
    }

    @Override
    public void diagnose(Vector<RecordInfo> v) {
        if (LOGIC_OR.equals(this.logic.toUpperCase(Locale.ENGLISH))) {
            this.diagnoseOrLogic(v);
        } else {
            this.diagnoseAndLogic(v);
        }
    }

    private void diagnoseOrLogic(Vector<RecordInfo> v) {
        Iterator<TableRowKeyValueColIterateCompare> iterator = this.compareList.iterator();
        if (iterator.hasNext()) {
            TableRowKeyValueColIterateCompare tableRowCompare = iterator.next();
            try {
                tableRowCompare.diagnose(v);
                return;
            }
            catch (DiagnoseCommandExecuteException e) {
                throw new DiagnoseCommandExecuteException("diagnoseOrLogic is error:", e);
            }
        }
    }

    private void diagnoseAndLogic(Vector<RecordInfo> v) {
        for (TableRowKeyValueColIterateCompare tableRowCompare : this.compareList) {
            tableRowCompare.diagnose(v);
        }
    }

    public void addTableRowKeyValueColIterateCompare(TableRowKeyValueColIterateCompare colIterateCompare) {
        this.compareList.add(colIterateCompare);
    }
}

