/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.faulttree.command.diagnose;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.loganalyzer.faulttree.command.enumer.RuleOperator;
import com.huawei.ism.tool.loganalyzer.faulttree.command.templet.DiagnoseCommand;
import com.huawei.ism.tool.loganalyzer.faulttree.exception.DiagnoseCommandExecuteException;
import com.huawei.ism.tool.loganalyzer.faulttree.rulesearch.model.RecordInfo;
import com.huawei.ism.tool.loganalyzer.faulttree.util.IOUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Pattern;
import org.slf4j.Logger;

public class TableRowKeyValueColIterateCompare
extends DiagnoseCommand {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(TableRowKeyValueColIterateCompare.class);
    private static final String LOGIC_OR = "OR";
    private static final Pattern REGEX_NULL_LINE = Pattern.compile("\\s{2,}");
    private static final Pattern TABLE_NAME_PATTERN = Pattern.compile("^[a-zA-Z ]+:$");
    private static final Pattern REGEX_DIVIDING_LINE = Pattern.compile("^[\\-\\s]+$");
    private static final String DEFAULT_TABLE_NAME = "NO_NAME";
    private final List<Command> cmdList = new ArrayList<Command>();
    private String tableName = "NO_NAME";
    private String logic = "and";

    public TableRowKeyValueColIterateCompare(String tableName, String logic) {
        if (!StringUtils.isNULLStr((String)tableName)) {
            this.tableName = tableName;
        }
        if (!StringUtils.isNULLStr((String)logic)) {
            this.logic = logic;
        }
    }

    @Override
    public void diagnose(Vector<RecordInfo> v) {
        HashMap<Command, Map<String, List<String>>> cmdValueMap = new HashMap<Command, Map<String, List<String>>>();
        for (RecordInfo recordInfo : v) {
            this.parseRecordContent(recordInfo, cmdValueMap);
        }
        if (LOGIC_OR.equals(this.logic.toUpperCase(Locale.ENGLISH))) {
            for (Map.Entry entry : cmdValueMap.entrySet()) {
                if (!((Command)entry.getKey()).exec((Map)entry.getValue())) continue;
                return;
            }
            throw new DiagnoseCommandExecuteException("cann't matched !");
        }
        for (Map.Entry entry : cmdValueMap.entrySet()) {
            if (((Command)entry.getKey()).exec((Map)entry.getValue())) continue;
            throw new DiagnoseCommandExecuteException("cann't matched !");
        }
    }

    public void addIncMapCol(String keyName, String valueName, String operator) {
        IncMapCol incMapCol = new IncMapCol();
        incMapCol.init(keyName, valueName, operator);
        this.cmdList.add(incMapCol);
    }

    public void addDecMapCol(String keyName, String valueName, String operator) {
        DecMapCol decMapCol = new DecMapCol();
        decMapCol.init(keyName, valueName, operator);
        this.cmdList.add(decMapCol);
    }

    private void parseRecordContent(RecordInfo ri, Map<Command, Map<String, List<String>>> cmdValueMap) {
        block5: {
            StringReader sr = null;
            BufferedReader br = null;
            try {
                try {
                    sr = new StringReader(ri.getContent().toString());
                    br = new BufferedReader(sr);
                    this.parseRecordContent(br, cmdValueMap);
                }
                catch (Exception e) {
                    LOGGER.info("already catch IOException" + e);
                    IOUtils.close((Closeable)sr);
                    IOUtils.close((Closeable)br);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                IOUtils.close(sr);
                IOUtils.close(br);
                throw throwable;
            }
            IOUtils.close((Closeable)sr);
            IOUtils.close((Closeable)br);
        }
    }

    private static final int getColIndex(String[] heads, String colName) {
        int i = 0;
        while (i < heads.length) {
            if (heads[i].trim().equalsIgnoreCase(colName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void parseRecordContent(BufferedReader br, Map<Command, Map<String, List<String>>> cmdValueMap) throws IOException {
        String lineContent = null;
        String[] colContent = null;
        String lastLine = null;
        String tabNa = DEFAULT_TABLE_NAME;
        String[] heads = null;
        br.readLine();
        while ((lineContent = br.readLine()) != null) {
            if ((lineContent = lineContent.trim()).equals("")) continue;
            if (TABLE_NAME_PATTERN.matcher(lineContent).matches()) {
                tabNa = lineContent.split(":")[0].trim();
                heads = null;
                lastLine = null;
                continue;
            }
            if (heads == null && REGEX_DIVIDING_LINE.matcher(lineContent).matches()) {
                if (StringUtils.isNULLStr((String)lastLine)) continue;
                heads = REGEX_NULL_LINE.split(lastLine);
                if (tabNa != null) continue;
                tabNa = this.tableName;
                continue;
            }
            if (heads == null) {
                lastLine = lineContent;
                continue;
            }
            colContent = REGEX_NULL_LINE.split(lineContent);
            if (!tabNa.equals(this.tableName) || colContent.length != heads.length) continue;
            for (Command command : this.cmdList) {
                command.parseValueFromLineContent(heads, colContent, cmdValueMap);
            }
        }
    }

    private static abstract class Command {
        String keyName;
        String valueName;
        RuleOperator operator = RuleOperator.IN;

        private Command() {
        }

        public abstract boolean exec(Map<String, List<String>> var1);

        public void parseValueFromLineContent(String[] heads, String[] colContent, Map<Command, Map<String, List<String>>> cmdValueMap) {
            List<String> valueList;
            int keyColIndex = TableRowKeyValueColIterateCompare.getColIndex(heads, this.keyName);
            int valueColIndex = TableRowKeyValueColIterateCompare.getColIndex(heads, this.valueName);
            if (keyColIndex != -1 && valueColIndex != -1) {
                String key;
                Map<String, List<String>> valueMap = cmdValueMap.get(this);
                if (valueMap == null) {
                    valueMap = new HashMap<String, List<String>>();
                    cmdValueMap.put(this, valueMap);
                }
                if ((valueList = valueMap.get(key = colContent[keyColIndex])) == null) {
                    valueList = new ArrayList<String>();
                    valueMap.put(key, valueList);
                }
            } else {
                throw new DiagnoseCommandExecuteException("Can't find the colName [" + this.keyName + " or " + this.valueName + "] from the table:\n" + Arrays.asList(heads));
            }
            valueList.add(colContent[valueColIndex]);
        }
    }

    private static class DecMapCol
    extends Command {
        private DecMapCol() {
        }

        private void init(String keyName, String valueName, String operator) {
            this.keyName = keyName;
            this.valueName = valueName;
            if (operator != null) {
                this.operator = RuleOperator.valueOf(operator.toUpperCase(Locale.ENGLISH));
            }
        }

        @Override
        public boolean exec(Map<String, List<String>> valueMap) {
            return true;
        }
    }

    private static class IncMapCol
    extends Command {
        private IncMapCol() {
        }

        private void init(String keyName, String valueName, String operator) {
            this.keyName = keyName;
            this.valueName = valueName;
            if (operator != null) {
                this.operator = RuleOperator.valueOf(operator.toUpperCase(Locale.ENGLISH));
            }
        }

        @Override
        public boolean exec(Map<String, List<String>> valueMap) {
            if (RuleOperator.IN == this.operator) {
                for (Map.Entry<String, List<String>> e : valueMap.entrySet()) {
                    List<String> valueNameList = e.getValue();
                    if (!this.isIncList(valueNameList)) continue;
                    return true;
                }
                return false;
            }
            for (Map.Entry<String, List<String>> e : valueMap.entrySet()) {
                List<String> valueNameList = e.getValue();
                if (!this.isIncList(valueNameList)) continue;
                return false;
            }
            return true;
        }

        private boolean isIncList(List<String> valueNameList) {
            if (valueNameList.isEmpty()) {
                return false;
            }
            return this.hasThreeDiffrentValue(valueNameList) && this.isInc(valueNameList);
        }

        private boolean hasThreeDiffrentValue(List<String> valueNameList) {
            HashSet<String> noRepeatSet = new HashSet<String>(valueNameList);
            return noRepeatSet.size() >= 3;
        }

        private boolean isInc(List<String> valueNameList) {
            String lastValue = valueNameList.get(valueNameList.size() - 1);
            String firstValue = valueNameList.get(0);
            try {
                return Integer.parseInt(lastValue) - Integer.parseInt(firstValue) > 0;
            }
            catch (NumberFormatException e) {
                throw new DiagnoseCommandExecuteException("colName [" + this.valueName + "'s value is not number ! ", e);
            }
        }
    }
}

