/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.faulttree.command.diagnose;

import com.huawei.ism.tool.loganalyzer.faulttree.command.diagnose.KeyValueIterateCompare;
import com.huawei.ism.tool.loganalyzer.faulttree.command.enumer.RuleOperator;
import com.huawei.ism.tool.loganalyzer.faulttree.command.templet.DiagnoseCommand;
import com.huawei.ism.tool.loganalyzer.faulttree.exception.DiagnoseCommandExecuteException;
import com.huawei.ism.tool.loganalyzer.faulttree.rulesearch.model.RecordInfo;
import com.huawei.ism.tool.loganalyzer.faulttree.util.IOUtils;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Pattern;
import org.dom4j.Element;
import org.slf4j.Logger;

public class TableRowMultiColIterateCompare
extends DiagnoseCommand {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(KeyValueIterateCompare.class);
    private static final String LOGIC_OR = "OR";
    private static final Pattern REGEX_NULL_LINE = Pattern.compile("\\s{2,}");
    private static final Pattern REGEX_DIVIDING_LINE = Pattern.compile("^[\\-\\s]+$");
    private static final List<String> FILTERLIST = new ArrayList<String>();
    private String keyWords;
    private String repeatColName;
    private String repeatTimes;
    private String logic = "AND";
    private RuleOperator ruleOperator = RuleOperator.GT;
    private int from;
    private int to;
    private List<ColValue> colValueList = new ArrayList<ColValue>();

    static {
        FILTERLIST.add("--");
    }

    public TableRowMultiColIterateCompare(Element commandEl, RuleOperator ruleOperator) {
        String logic1;
        this.keyWords = commandEl.attributeValue("keyWords");
        this.repeatColName = commandEl.attributeValue("repeatColName");
        if (ruleOperator != null) {
            this.ruleOperator = ruleOperator;
        }
        if ((logic1 = commandEl.attributeValue("logic")) != null) {
            this.logic = logic1;
        }
        this.repeatTimes = commandEl.attributeValue("repeatTimes");
        String from2 = commandEl.attributeValue("from");
        String to2 = commandEl.attributeValue("to");
        if (from2 != null && to2 != null) {
            this.from = Integer.parseInt(from2);
            this.to = Integer.parseInt(to2);
        }
    }

    @Override
    public void diagnose(Vector<RecordInfo> v) {
        boolean flag = false;
        for (RecordInfo recordInfo : v) {
            List<Map<String, String>> data = this.parseRecordContent(recordInfo);
            if (!this.doDiagnose(data)) continue;
            flag = true;
            break;
        }
        if (!flag) {
            throw new DiagnoseCommandExecuteException("Match failed!");
        }
    }

    public Set<String> getRepeatColValue(Vector<RecordInfo> v) {
        HashSet<String> repeatColValues = new HashSet<String>();
        for (RecordInfo recordInfo : v) {
            List<Map<String, String>> data = this.parseRecordContent(recordInfo);
            List<Map<String, String>> matchRow = this.getMatchRow(data);
            repeatColValues.addAll(this.getRepeatColValues(matchRow));
        }
        return repeatColValues;
    }

    private boolean doDiagnose(List<Map<String, String>> data) {
        boolean isSuccess = false;
        try {
            List<Map<String, String>> matchRow = this.getMatchRow(data);
            isSuccess = this.getRepeatColValues(matchRow).size() > 0;
        }
        catch (Exception e) {
            LOGGER.error("dodiagnose eroor", (Throwable)e);
        }
        return isSuccess;
    }

    private List<Map<String, String>> getMatchRow(List<Map<String, String>> data) {
        ArrayList<Map<String, String>> matchRow = new ArrayList<Map<String, String>>();
        for (Map<String, String> row : data) {
            if (row.get(this.repeatColName) != null && this.isNeedFilter(row.get(this.repeatColName).trim()) || !this.isMatchRow(row)) continue;
            matchRow.add(row);
        }
        return matchRow;
    }

    private boolean isNeedFilter(String value) {
        for (String str : FILTERLIST) {
            if (!str.equals(value)) continue;
            return true;
        }
        return false;
    }

    private boolean isMatchRow(Map<String, String> row) {
        if (LOGIC_OR.equals(this.logic.toUpperCase(Locale.ENGLISH))) {
            for (ColValue colValue : this.colValueList) {
                boolean isSuccess = colValue.getOperator().isSuccess(row.get(colValue.key), colValue.value, colValue.from, colValue.to);
                if (!isSuccess) continue;
                return true;
            }
            return false;
        }
        for (ColValue colValue : this.colValueList) {
            boolean isSuccess = colValue.getOperator().isSuccess(row.get(colValue.key), colValue.value, colValue.from, colValue.to);
            if (isSuccess) continue;
            return false;
        }
        return true;
    }

    private Set<String> getRepeatColValues(List<Map<String, String>> matchRow) {
        HashMap<String, Integer> repeatMap = new HashMap<String, Integer>();
        for (Map<String, String> row : matchRow) {
            Integer repeatTimes1 = (Integer)repeatMap.get(row.get(this.repeatColName));
            if (repeatTimes1 != null) {
                repeatMap.put(row.get(this.repeatColName), repeatTimes1 + 1);
                continue;
            }
            repeatMap.put(row.get(this.repeatColName), 1);
        }
        HashSet<String> repeatColValues = new HashSet<String>();
        for (Map.Entry times : repeatMap.entrySet()) {
            if (!this.ruleOperator.isSuccess(String.valueOf(times.getValue()), this.repeatTimes, this.from, this.to)) continue;
            repeatColValues.add((String)times.getKey());
        }
        return repeatColValues;
    }

    private List<Map<String, String>> parseRecordContent(RecordInfo ri) {
        List<Map<String, String>> data;
        block5: {
            StringReader sr = null;
            BufferedReader br = null;
            data = new ArrayList<Map<String, String>>();
            try {
                try {
                    sr = new StringReader(ri.getContent().toString());
                    br = new BufferedReader(sr);
                    data = this.doParse(br);
                }
                catch (Exception e) {
                    LOGGER.info("already catch IOException", (Throwable)e);
                    IOUtils.close((Closeable)sr);
                    IOUtils.close(br);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                IOUtils.close(sr);
                IOUtils.close(br);
                throw throwable;
            }
            IOUtils.close((Closeable)sr);
            IOUtils.close((Closeable)br);
        }
        return data;
    }

    /*
     * Unable to fully structure code
     */
    private List<Map<String, String>> doParse(BufferedReader br) throws IOException {
        lineContent = null;
        colContent = null;
        lastLine = null;
        heads = null;
        data = new ArrayList<Map<String, String>>();
        firstLine = br.readLine();
        if (firstLine == null || firstLine.contains(this.keyWords)) ** GOTO lbl20
        return data;
lbl-1000:
        // 1 sources

        {
            lineContent = lineContent.trim();
            if (heads == null && TableRowMultiColIterateCompare.REGEX_DIVIDING_LINE.matcher(lineContent).matches()) {
                heads = TableRowMultiColIterateCompare.REGEX_NULL_LINE.split(lastLine);
                continue;
            }
            if (heads == null) {
                lastLine = lineContent;
                continue;
            }
            colContent = TableRowMultiColIterateCompare.REGEX_NULL_LINE.split(lineContent);
            if (colContent.length != heads.length) break;
            data.add(this.getRow(heads, colContent));
lbl20:
            // 4 sources

            ** while ((lineContent = br.readLine()) != null)
        }
lbl21:
        // 2 sources

        return data;
    }

    private Map<String, String> getRow(String[] heads, String[] colContent) {
        HashMap<String, String> row = new HashMap<String, String>();
        int i = 0;
        while (i < colContent.length) {
            row.put(heads[i], colContent[i]);
            ++i;
        }
        return row;
    }

    public void add(String key, String value, int fr, int toto, RuleOperator operator) {
        ColValue colValue = new ColValue();
        colValue.init(operator, key, value, fr, toto);
        this.colValueList.add(colValue);
    }

    public static final class ColValue {
        private RuleOperator operator = RuleOperator.IN;
        private String key;
        private String value;
        private int from;
        private int to;

        private void init(RuleOperator operators, String key1, String value1, int from1, int to1) {
            this.key = key1;
            this.value = value1;
            this.from = from1;
            this.to = to1;
            if (operators != null) {
                this.operator = operators;
            }
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public RuleOperator getOperator() {
            return this.operator;
        }

        public int getFrom() {
            return this.from;
        }

        public int getTo() {
            return this.to;
        }

        public String toString() {
            return "ColValue [operator=" + (Object)((Object)this.operator) + ", key=" + this.key + ", value=" + this.value + ", from=" + this.from + ", to=" + this.to + "]";
        }
    }
}

