/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.faulttree.command.diagnose;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.loganalyzer.faulttree.command.enumer.RuleOperator;
import com.huawei.ism.tool.loganalyzer.faulttree.command.templet.DiagnoseCommand;
import com.huawei.ism.tool.loganalyzer.faulttree.exception.DiagnoseCommandExecuteException;
import com.huawei.ism.tool.loganalyzer.faulttree.rulesearch.model.RecordInfo;
import com.huawei.ism.tool.loganalyzer.faulttree.util.IOUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.StringReader;
import java.util.Vector;
import java.util.regex.Pattern;
import org.dom4j.Element;
import org.slf4j.Logger;

public class TableRowSingleColIterateCompare
extends DiagnoseCommand {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(TableRowSingleColIterateCompare.class);
    private static final Pattern REGEX_NULL_LINE = Pattern.compile("\\s{2,}");
    private static final Pattern REGEX_DIVIDING_LINE = Pattern.compile("^[\\-\\s]+$");
    private RuleOperator operator = RuleOperator.IN;
    private String logic = "and";
    private String colName;
    private String compareValue;
    private int from;
    private int to;
    private boolean isFormatErrorNormal = true;

    public TableRowSingleColIterateCompare(RuleOperator ruleOperator, Element commandEl) {
        this.operator = ruleOperator;
        this.colName = commandEl.attributeValue("colName");
        this.compareValue = commandEl.attributeValue("compareValue");
        String logi = commandEl.attributeValue("logic");
        if (logi != null) {
            this.logic = logi;
        }
        String fromStr = commandEl.attributeValue("from");
        int fr = 0;
        if (fromStr != null) {
            fr = Integer.parseInt(fromStr);
        }
        String toStr = commandEl.attributeValue("to");
        int toto = 0;
        if (toStr != null) {
            toto = Integer.parseInt(toStr);
        }
        this.from = fr;
        this.to = toto;
        String isFormatErrorNormalStr = commandEl.attributeValue("isFormatErrorNormal");
        boolean isFormatErrorNor = true;
        if (isFormatErrorNormalStr != null) {
            isFormatErrorNor = Boolean.parseBoolean(isFormatErrorNormalStr);
        }
        this.isFormatErrorNormal = isFormatErrorNor;
    }

    @Override
    public void diagnose(Vector<RecordInfo> v) {
        StringReader sr = null;
        BufferedReader br = null;
        if (this.logic.equals("and")) {
            for (RecordInfo recordInfo : v) {
                try {
                    try {
                        sr = new StringReader(recordInfo.getContent().toString());
                        br = new BufferedReader(sr);
                        this.doDiagnose(br);
                    }
                    catch (IOException e) {
                        LOGGER.info("already catch IOException" + e);
                        IOUtils.close((Closeable)sr);
                        IOUtils.close((Closeable)br);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.close(sr);
                    IOUtils.close(br);
                    throw throwable;
                }
                IOUtils.close((Closeable)sr);
                IOUtils.close((Closeable)br);
            }
        } else {
            for (RecordInfo recordInfo : v) {
                try {
                    sr = new StringReader(recordInfo.getContent().toString());
                    br = new BufferedReader(sr);
                    this.doDiagnose(br);
                }
                catch (DiagnoseCommandExecuteException e) {
                    IOUtils.close(sr);
                    IOUtils.close(br);
                    return;
                }
                catch (IOException e) {
                    try {
                        LOGGER.info("already catch IOException" + e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.close(sr);
                        IOUtils.close(br);
                        throw throwable;
                    }
                    IOUtils.close((Closeable)sr);
                    IOUtils.close((Closeable)br);
                    continue;
                }
                IOUtils.close((Closeable)sr);
                IOUtils.close((Closeable)br);
            }
            throw new DiagnoseCommandExecuteException("cann't matched");
        }
    }

    private void doDiagnose(BufferedReader br) throws IOException {
        String lineContent = null;
        String[] colContent = null;
        String lastLine = null;
        String[] heads = null;
        int colIndex = -1;
        boolean existHead = false;
        while ((lineContent = br.readLine()) != null) {
            if (StringUtils.isNULLStr((String)(lineContent = lineContent.trim()))) continue;
            if (heads == null && REGEX_DIVIDING_LINE.matcher(lineContent).matches()) {
                heads = REGEX_NULL_LINE.split(lastLine);
                colIndex = this.getColIndex(heads, this.colName);
                lastLine = null;
                existHead = true;
                continue;
            }
            if (heads == null) {
                lastLine = lineContent;
                continue;
            }
            if (colIndex == -1) {
                throw new DiagnoseCommandExecuteException("cann't matched");
            }
            colContent = REGEX_NULL_LINE.split(lineContent);
            if (colContent.length != heads.length || !(this.logic.equals("and") ? !this.operator.isSuccess(colContent[colIndex], this.compareValue, this.from, this.to) : this.operator.isSuccess(colContent[colIndex], this.compareValue, this.from, this.to))) continue;
            throw new DiagnoseCommandExecuteException("cann't matched");
        }
        this.checkDiagnoseCommandExecute(existHead);
    }

    private void checkDiagnoseCommandExecute(boolean existHead) {
        if (this.isFormatErrorNormal ? this.logic.equals("and") && !existHead : !existHead && this.logic.equals("or")) {
            throw new DiagnoseCommandExecuteException("cann't matched");
        }
    }

    private int getColIndex(String[] heads, String colNam) {
        int i = 0;
        while (i < heads.length) {
            if (heads[i].trim().equals(colNam)) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

