/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.faulttree.command.diagnose;

import com.huawei.ism.tool.loganalyzer.faulttree.command.diagnose.RSCNBean;
import com.huawei.ism.tool.loganalyzer.faulttree.command.templet.DiagnoseCommand;
import com.huawei.ism.tool.loganalyzer.faulttree.exception.DiagnoseCommandExecuteException;
import com.huawei.ism.tool.loganalyzer.faulttree.rulesearch.model.RecordInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class TwiceRSCNCheck
extends DiagnoseCommand {
    private static final Logger LOGGER = Logger.getLogger(TwiceRSCNCheck.class);
    private List<RSCNBean> list = new ArrayList<RSCNBean>();
    private Vector<RecordInfo> vector = new Vector();

    @Override
    public void diagnose(Vector<RecordInfo> v) {
        this.list.clear();
        this.vector.clear();
        int count = 0;
        int tempLineNum = 0;
        String lastRecordInfo = "";
        for (RecordInfo recordInfo : v) {
            if (recordInfo.getLineNumber() - tempLineNum == 1) {
                RSCNBean rscnBean = new RSCNBean();
                this.putParamToMap(recordInfo, lastRecordInfo, rscnBean);
            }
            tempLineNum = recordInfo.getLineNumber();
            lastRecordInfo = recordInfo.getContent().toString();
        }
        if (this.list.size() > 1) {
            RSCNBean tempbean = null;
            for (RSCNBean rscnbean : this.list) {
                if (tempbean != null && tempbean.equals(rscnbean) && Math.abs(tempbean.getTime() - rscnbean.getTime()) <= 2000L) {
                    ++count;
                    this.vector.add(rscnbean.getRecordInfo());
                    this.vector.add(tempbean.getRecordInfo());
                }
                tempbean = rscnbean;
            }
        }
        if (count == 0) {
            throw new DiagnoseCommandExecuteException("twiceRSCNCheck Failed!");
        }
        v.removeAllElements();
        v.addAll(this.vector);
    }

    private void putParamToMap(RecordInfo recordInfo, String lastRecordInfo, RSCNBean rscnBean) {
        Pattern pattern;
        Matcher matcher;
        if (lastRecordInfo.contains("---->RSCN")) {
            String afterRSCN = lastRecordInfo.split("---->RSCN:")[1];
            rscnBean.setPort1(afterRSCN.split("\\s")[0]);
            rscnBean.setPort2(afterRSCN.split("\\s")[7]);
            rscnBean.setTime(recordInfo.getDateInfo().getTime());
            rscnBean.setRecordInfo(recordInfo);
        }
        if (recordInfo.getContent().toString().contains("pageInfo") && (matcher = (pattern = Pattern.compile("pageInfo = (\\d+)")).matcher(recordInfo.getContent().toString())).find()) {
            rscnBean.setPort3(matcher.group(1));
        }
        this.list.add(rscnBean);
    }
}

