/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.faulttree.command.diagnose;

import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.loganalyzer.faulttree.command.diagnose.KeyValueCompare;
import com.huawei.ism.tool.loganalyzer.faulttree.command.templet.DiagnoseCommand;
import com.huawei.ism.tool.loganalyzer.faulttree.exception.DiagnoseCommandExecuteException;
import com.huawei.ism.tool.loganalyzer.faulttree.rulesearch.model.RecordInfo;
import com.huawei.ism.tool.loganalyzer.faulttree.util.IOUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.StringReader;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;

public class TxRxPowerCheck
extends DiagnoseCommand {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(KeyValueCompare.class);
    private static final Pattern VALUE_MATCHER = Pattern.compile("\\d+\\s*\\[\\s*\\d+\\s*\\-\\s*\\d+\\s*\\]");
    private boolean matcher = false;

    @Override
    public void diagnose(Vector<RecordInfo> v) {
        StringReader sr = null;
        BufferedReader br = null;
        String content = null;
        int count = 0;
        for (RecordInfo recordInfo : v) {
            try {
                try {
                    String lineContent;
                    content = recordInfo.getContent().toString();
                    sr = new StringReader(content);
                    br = new BufferedReader(sr);
                    boolean isLink = false;
                    while ((lineContent = br.readLine()) != null) {
                        String[] linkStates = lineContent.trim().split(":");
                        if (linkStates.length == 2 && linkStates[0].trim().equals("Link status") && linkStates[1].trim().equals("Link Up")) {
                            isLink = true;
                        }
                        if (!isLink) continue;
                        count = this.matchNumber(count, lineContent);
                    }
                }
                catch (IOException e) {
                    LOGGER.info("already catch IOException" + e);
                    IOUtils.close((Closeable)sr);
                    IOUtils.close((Closeable)br);
                    continue;
                }
            }
            catch (Throwable throwable) {
                IOUtils.close(sr);
                IOUtils.close(br);
                throw throwable;
            }
            IOUtils.close((Closeable)sr);
            IOUtils.close((Closeable)br);
        }
        if (count == 0) {
            throw new DiagnoseCommandExecuteException("TxRxPowerCheck Failed!");
        }
    }

    private int matchNumber(int count, String lineContent) {
        Matcher mat;
        String[] keyValues;
        if ((lineContent.trim().startsWith("Tx power") || lineContent.trim().startsWith("Rx power")) && (keyValues = lineContent.trim().split(":")).length > 1 && (mat = VALUE_MATCHER.matcher(keyValues[1].trim())).find()) {
            this.matcher = this.doDiagnose(keyValues[1].trim());
            if (!this.matcher) {
                ++count;
            }
        }
        return count;
    }

    private boolean doDiagnose(String br) {
        long value = Long.parseLong(br.substring(0, br.indexOf("[")).trim());
        long minRange = Long.parseLong(br.substring(br.indexOf("[") + 1, br.indexOf("-")).trim());
        long maxRange = Long.parseLong(br.substring(br.indexOf("-") + 1, br.indexOf("]")).trim());
        return minRange <= value && value <= maxRange;
    }
}

