/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.faulttree.command.enumer;

import com.huawei.ism.tool.loganalyzer.faulttree.util.MatcherUtils;
import java.util.regex.Pattern;

public enum RuleOperator {
    LT,
    GT,
    EQ,
    NE,
    LE,
    GE,
    RG,
    IN,
    NI;


    public boolean isSuccess(String result, String compareValue, int from, int to) {
        try {
            switch (this) {
                case LT: {
                    return Integer.parseInt(result) < Integer.parseInt(compareValue);
                }
                case GT: {
                    return Integer.parseInt(result) > Integer.parseInt(compareValue);
                }
                case EQ: {
                    return Integer.parseInt(result) == Integer.parseInt(compareValue);
                }
                case NE: {
                    return Integer.parseInt(result) != Integer.parseInt(compareValue);
                }
                case LE: {
                    return Integer.parseInt(result) <= Integer.parseInt(compareValue);
                }
                case GE: {
                    return Integer.parseInt(result) >= Integer.parseInt(compareValue);
                }
                case RG: {
                    return from <= Integer.parseInt(result) && Integer.parseInt(result) <= to;
                }
                case IN: {
                    return MatcherUtils.isMatch(result, Pattern.compile(compareValue));
                }
                case NI: {
                    return !MatcherUtils.isMatch(result, Pattern.compile(compareValue));
                }
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isSuccess(boolean result) {
        return this == IN ? result : !result;
    }
}

