/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.faulttree.command.match;

import com.huawei.ism.tool.loganalyzer.faulttree.command.enumer.RuleOperator;
import com.huawei.ism.tool.loganalyzer.faulttree.command.model.DateInfo;
import com.huawei.ism.tool.loganalyzer.faulttree.command.templet.MatchCommand;
import com.huawei.ism.tool.loganalyzer.faulttree.exception.RegexCompileException;
import com.huawei.ism.tool.loganalyzer.faulttree.util.IOUtils;
import com.huawei.ism.tool.loganalyzer.silence.SilenceInvoke;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.Locale;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Logger;

public class Contains
extends MatchCommand {
    private String value;
    private boolean ignoreCase;
    private RuleOperator operator = RuleOperator.IN;
    private static final Logger LOGGER = Logger.getLogger(SilenceInvoke.class);

    public Contains() {
    }

    public Contains(String value, String ignoreCase, RuleOperator operator) {
        try {
            this.value = value;
            this.ignoreCase = Boolean.parseBoolean(ignoreCase);
            if (operator != null) {
                this.operator = operator;
            }
            this.setNotMatchedMsg("Contains command execute failed : " + value);
        }
        catch (Exception e) {
            throw new RegexCompileException("Pattern compile fail, The format of the regex is wrong, please check \uff1a " + value, e);
        }
    }

    @Override
    public boolean isMatch(CharSequence content) {
        if (this.ignoreCase) {
            return this.operator.isSuccess(content.toString().toLowerCase(Locale.ENGLISH).contains(this.value.toLowerCase(Locale.ENGLISH)));
        }
        boolean isContains = false;
        isContains = content instanceof StringBuilder ? ((StringBuilder)content).indexOf(this.value) > -1 : (content instanceof StringBuffer ? ((StringBuffer)content).indexOf(this.value) > -1 : String.valueOf(content).contains(this.value));
        return this.operator.isSuccess(isContains);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public DateInfo find(CharSequence content) {
        DateInfo dateInfo;
        StringReader sr = null;
        BufferedReader br = null;
        try {
            DateInfo di;
            sr = new StringReader(this.ignoreCase ? content.toString().toLowerCase(Locale.ENGLISH) : content.toString());
            br = new BufferedReader(sr);
            String lineContent = null;
            String dateLineContent = null;
            while ((lineContent = br.readLine()) != null) {
                if (!lineContent.contains(this.ignoreCase ? this.value.toLowerCase(Locale.ENGLISH) : this.value)) continue;
                dateLineContent = lineContent;
            }
            DateInfo dateInfo2 = di = dateLineContent == null ? null : this.findDateInfoFromLineContent(dateLineContent);
            if (di == null) {
                di = this.findDateInfoFromLineContent(content);
            }
            dateInfo = di;
        }
        catch (Exception e) {
            try {
                LogFactory.getLog(Contains.class).debug((Object)"ignoreCase is error:", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.close(sr, br);
                throw throwable;
            }
            IOUtils.close(sr, br);
            return null;
        }
        IOUtils.close(sr, br);
        return dateInfo;
    }
}

