/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.faulttree.command.match;

import com.huawei.ism.tool.loganalyzer.faulttree.command.enumer.RuleOperator;
import com.huawei.ism.tool.loganalyzer.faulttree.command.model.DateInfo;
import com.huawei.ism.tool.loganalyzer.faulttree.command.templet.MatchCommand;
import com.huawei.ism.tool.loganalyzer.faulttree.exception.RegexCompileException;
import com.huawei.ism.tool.loganalyzer.faulttree.util.MatcherUtils;
import java.util.regex.Pattern;

public class Regex
extends MatchCommand {
    Pattern valuePattern;
    RuleOperator operator = RuleOperator.IN;

    Regex() {
    }

    public Regex(String value, RuleOperator operator) {
        try {
            this.valuePattern = Pattern.compile(value);
            if (operator != null) {
                this.operator = operator;
            }
            this.setNotMatchedMsg("The Regex command execute failed : " + this.valuePattern.pattern());
        }
        catch (Exception e) {
            throw new RegexCompileException("Pattern compile fail, The format of the regex is wrong, please check \uff1a " + value, e);
        }
    }

    @Override
    public boolean isMatch(CharSequence content) {
        return this.operator.isSuccess(MatcherUtils.isMatch(content, this.valuePattern));
    }

    @Override
    public DateInfo find(CharSequence content) {
        DateInfo di = null;
        String lastLineContent = MatcherUtils.getLastLineContent(content, this.valuePattern);
        if (lastLineContent != null) {
            di = this.findDateInfoFromLineContent(lastLineContent);
        }
        if (di == null) {
            di = this.findDateInfoFromLineContent(content);
        }
        return di;
    }
}

