/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.faulttree.command.match;

import com.huawei.ism.tool.loganalyzer.faulttree.command.enumer.RuleOperator;
import com.huawei.ism.tool.loganalyzer.faulttree.command.match.Regex;
import com.huawei.ism.tool.loganalyzer.faulttree.exception.RegexCompileException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class Wildcard
extends Regex {
    private static final Map<String, String> REG_EXP_CHAR_MAP = new HashMap<String, String>();

    static {
        REG_EXP_CHAR_MAP.put("+", "\\+");
        REG_EXP_CHAR_MAP.put("-", "\\-");
        REG_EXP_CHAR_MAP.put("^", "\\^");
        REG_EXP_CHAR_MAP.put("$", "\\$");
        REG_EXP_CHAR_MAP.put("(", "\\(");
        REG_EXP_CHAR_MAP.put(")", "\\)");
        REG_EXP_CHAR_MAP.put("[", "\\[");
        REG_EXP_CHAR_MAP.put("]", "\\]");
        REG_EXP_CHAR_MAP.put("{", "\\{");
        REG_EXP_CHAR_MAP.put("}", "\\}");
        REG_EXP_CHAR_MAP.put(".", "\\.");
        REG_EXP_CHAR_MAP.put("*", ".*");
        REG_EXP_CHAR_MAP.put("|", "\\|");
        REG_EXP_CHAR_MAP.put("~", "\\~");
        REG_EXP_CHAR_MAP.put("?", "\\?");
    }

    public Wildcard(String value, RuleOperator operator) {
        try {
            this.valuePattern = Pattern.compile(this.transferToRegex(value).toString());
            if (operator != null) {
                this.operator = operator;
            }
            this.setNotMatchedMsg("The Wildcard command execute failed : " + this.valuePattern.pattern());
        }
        catch (Exception e) {
            throw new RegexCompileException("Pattern compile fail, The format of the regex is wrong, please check \uff1a " + value, e);
        }
    }

    private StringBuilder transferToRegex(String value) {
        value = value.replaceAll("^\\*|\\*$", "");
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < value.length()) {
            String k = String.valueOf(value.charAt(i));
            String val = REG_EXP_CHAR_MAP.get(k);
            sb.append(val != null ? val : k);
            ++i;
        }
        return sb;
    }
}

