/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.faulttree.command.parser.diagnose;

import com.huawei.ism.tool.loganalyzer.faulttree.command.diagnose.Count;
import com.huawei.ism.tool.loganalyzer.faulttree.command.enumer.RuleOperator;
import com.huawei.ism.tool.loganalyzer.faulttree.command.templet.DiagnoseCommand;
import com.huawei.ism.tool.loganalyzer.faulttree.command.templet.DiagnoseCommandParser;
import com.huawei.ism.tool.loganalyzer.faulttree.exception.XmlParseException;
import java.util.Locale;
import org.dom4j.Element;

public class CountParser
extends DiagnoseCommandParser {
    @Override
    public DiagnoseCommand parse(Element commandEl) {
        String fromStr = commandEl.attributeValue("from");
        String toStr = commandEl.attributeValue("to");
        String operator = commandEl.attributeValue("operator");
        RuleOperator ruleOperator = RuleOperator.GT;
        if (operator != null) {
            ruleOperator = RuleOperator.valueOf(operator.toUpperCase(Locale.ENGLISH));
        }
        String value = commandEl.attributeValue("value");
        if (ruleOperator != RuleOperator.RG) {
            if (value == null) {
                throw new XmlParseException("Count diagnose command parse error,compareValue is empty.");
            }
        } else if (fromStr == null || toStr == null) {
            throw new XmlParseException("Count diagnose command parse error,from ,to is empty.");
        }
        int from = 0;
        if (fromStr != null) {
            from = Integer.parseInt(fromStr);
        }
        int to = 0;
        if (toStr != null) {
            to = Integer.parseInt(toStr);
        }
        return new Count(ruleOperator, value, from, to);
    }
}

