/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.faulttree.command.parser.diagnose;

import com.huawei.ism.tool.loganalyzer.faulttree.command.diagnose.IntegerCompare;
import com.huawei.ism.tool.loganalyzer.faulttree.command.enumer.RuleOperator;
import com.huawei.ism.tool.loganalyzer.faulttree.command.templet.DiagnoseCommand;
import com.huawei.ism.tool.loganalyzer.faulttree.command.templet.DiagnoseCommandParser;
import com.huawei.ism.tool.loganalyzer.faulttree.exception.XmlParseException;
import java.util.List;
import java.util.Locale;
import org.dom4j.Element;

public class IntegerCompareParser
extends DiagnoseCommandParser {
    @Override
    public DiagnoseCommand parse(Element commandEl) {
        try {
            String fromStr = commandEl.attributeValue("from");
            String toStr = commandEl.attributeValue("to");
            String operator = commandEl.attributeValue("operator");
            RuleOperator ruleOperator = RuleOperator.GT;
            if (operator != null) {
                ruleOperator = RuleOperator.valueOf(operator.toUpperCase(Locale.ENGLISH));
            }
            String compareValueStr = commandEl.attributeValue("compareValue");
            if (ruleOperator != RuleOperator.RG) {
                if (compareValueStr == null) {
                    throw new XmlParseException("IntegerCompare diagnose command parse error,compareValue is empty.");
                }
            } else if (fromStr == null || toStr == null) {
                throw new XmlParseException("IntegerCompare diagnose command parse error,from ,to is empty.");
            }
            boolean isBinary = Boolean.getBoolean(commandEl.attributeValue("isBinary"));
            IntegerCompare integerCompare = new IntegerCompare(ruleOperator, compareValueStr, isBinary, fromStr, fromStr);
            List<Element> regexElList = IntegerCompareParser.getElementList(commandEl, "Regex");
            if (regexElList.isEmpty()) {
                throw new XmlParseException("IntegerCompare diagnose command parse error, Can't find the Regex tag.");
            }
            for (Element regexEl : regexElList) {
                String value = regexEl.attributeValue("value");
                if (value == null) {
                    throw new XmlParseException("IntegerCompare diagnose command parse error, Regex's attr[value] isn't found.");
                }
                int indexStr = 0;
                if (regexEl.attributeValue("index") != null) {
                    indexStr = Integer.parseInt(regexEl.attributeValue("index"));
                }
                integerCompare.add(value, indexStr);
            }
            return integerCompare;
        }
        catch (Exception e) {
            throw new XmlParseException("IntegerCompare diagnose command parse error:" + commandEl, e);
        }
    }
}

