/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.faulttree.command.parser.diagnose;

import com.huawei.ism.tool.loganalyzer.faulttree.command.diagnose.KeyValueIterateCompare;
import com.huawei.ism.tool.loganalyzer.faulttree.command.enumer.RuleOperator;
import com.huawei.ism.tool.loganalyzer.faulttree.command.templet.DiagnoseCommand;
import com.huawei.ism.tool.loganalyzer.faulttree.command.templet.DiagnoseCommandParser;
import com.huawei.ism.tool.loganalyzer.faulttree.exception.XmlParseException;
import java.util.List;
import java.util.Locale;
import org.dom4j.Element;

public class KeyValueIterateCompareParser
extends DiagnoseCommandParser {
    @Override
    public DiagnoseCommand parse(Element commandEl) {
        List<Element> keyValueElList = KeyValueIterateCompareParser.getElementList(commandEl, "KeyValue");
        if (keyValueElList.isEmpty()) {
            throw new XmlParseException("KeyValueIterateCompare diagnose command parse error, Can't find the KeyValue tag.");
        }
        KeyValueIterateCompare keyValueIterateCompare = new KeyValueIterateCompare();
        for (Element keyValueEl : keyValueElList) {
            String key = keyValueEl.attributeValue("key");
            if (key == null) {
                throw new XmlParseException("KeyValueIterateCompare diagnose command parse error, KeyValue's attr[key] isn't found.");
            }
            String fromStr = keyValueEl.attributeValue("from");
            int from = 0;
            if (fromStr != null) {
                from = Integer.parseInt(fromStr);
            }
            String toStr = keyValueEl.attributeValue("to");
            int to = 0;
            if (toStr != null) {
                to = Integer.parseInt(toStr);
            }
            String operator = keyValueEl.attributeValue("operator");
            RuleOperator ruleOperator = null;
            if (operator != null) {
                ruleOperator = RuleOperator.valueOf(operator.toUpperCase(Locale.ENGLISH));
            }
            keyValueIterateCompare.add(key, keyValueEl.attributeValue("value"), from, to, ruleOperator);
        }
        return keyValueIterateCompare;
    }
}

