/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.faulttree.command.parser.diagnose;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.loganalyzer.faulttree.command.diagnose.MultiTableRowKeyValueColIterateCompare;
import com.huawei.ism.tool.loganalyzer.faulttree.command.diagnose.TableRowKeyValueColIterateCompare;
import com.huawei.ism.tool.loganalyzer.faulttree.command.parser.diagnose.TableRowKeyValueColIterateCompareParser;
import com.huawei.ism.tool.loganalyzer.faulttree.command.templet.DiagnoseCommand;
import com.huawei.ism.tool.loganalyzer.faulttree.command.templet.DiagnoseCommandParser;
import com.huawei.ism.tool.loganalyzer.faulttree.exception.RuleParseException;
import java.util.List;
import java.util.Locale;
import org.dom4j.Element;

public class MultiTableRowKeyValueColIterateCompareParser
extends DiagnoseCommandParser {
    private static final String ELEMENT_LOGIC = "logic";
    private static final String LOGIC_OR = "OR";
    private static final String LOGIC_AND = "AND";

    @Override
    public DiagnoseCommand parse(Element commandEl) {
        String logicValue = commandEl.attributeValue(ELEMENT_LOGIC);
        List<Element> tableRowCompareList = MultiTableRowKeyValueColIterateCompareParser.getElementList(commandEl);
        this.checkParameter(logicValue, tableRowCompareList);
        MultiTableRowKeyValueColIterateCompare multiTableColIterateCompare = new MultiTableRowKeyValueColIterateCompare(logicValue);
        this.parserTableRowKeyValueColIterateCompares(tableRowCompareList, multiTableColIterateCompare);
        return multiTableColIterateCompare;
    }

    private void parserTableRowKeyValueColIterateCompares(List<Element> tableRowCompareList, MultiTableRowKeyValueColIterateCompare multiTableColIterateCompare) {
        for (Element tableRowCompareEl : tableRowCompareList) {
            TableRowKeyValueColIterateCompareParser compareParser = new TableRowKeyValueColIterateCompareParser();
            TableRowKeyValueColIterateCompare colIterateCompare = (TableRowKeyValueColIterateCompare)compareParser.parse(tableRowCompareEl);
            multiTableColIterateCompare.addTableRowKeyValueColIterateCompare(colIterateCompare);
        }
    }

    private void checkParameter(String logicValue, List<Element> mapColElList) {
        if (!(StringUtils.isNULLStr((String)logicValue) || LOGIC_OR.equals(logicValue.toUpperCase(Locale.ENGLISH)) || LOGIC_AND.equals(logicValue.toUpperCase(Locale.ENGLISH)))) {
            throw new RuleParseException("illegal logic's value in the tag <TableRowKeyValueColIterateCompare> .");
        }
        if (mapColElList == null || mapColElList.isEmpty()) {
            throw new RuleParseException("Can't find the IncMapCol command tag or DecMapCol command tag in the tag <DiagnoseCommands> .");
        }
    }
}

