/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.faulttree.command.parser.diagnose;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.loganalyzer.faulttree.command.diagnose.TableRowKeyValueColIterateCompare;
import com.huawei.ism.tool.loganalyzer.faulttree.command.templet.DiagnoseCommand;
import com.huawei.ism.tool.loganalyzer.faulttree.command.templet.DiagnoseCommandParser;
import com.huawei.ism.tool.loganalyzer.faulttree.exception.RuleParseException;
import java.util.List;
import java.util.Locale;
import org.dom4j.Element;

public class TableRowKeyValueColIterateCompareParser
extends DiagnoseCommandParser {
    private static final String ELEMENT_LOGIC = "logic";
    private static final String ELEMENT_TABLE_NAME = "tableName";
    private static final String ELEMENT_INCMAPCOL = "IncMapCol";
    private static final String ELEMENT_DECMAPCOL = "DecMapCol";
    private static final String ATTRIBUTE_KEYNAME = "keyName";
    private static final String ATTRIBUTE_VALUENAME = "valueName";
    private static final String ATTRIBUTE_OPERATOR = "operator";
    private static final String LOGIC_OR = "OR";
    private static final String LOGIC_AND = "AND";
    private static final String OPERATOR_IN = "IN";
    private static final String OPERATOR_NI = "NI";

    @Override
    public DiagnoseCommand parse(Element commandEl) {
        String logicValue = commandEl.attributeValue(ELEMENT_LOGIC);
        String tableNameValue = commandEl.attributeValue(ELEMENT_TABLE_NAME);
        List<Element> mapColElList = TableRowKeyValueColIterateCompareParser.getElementList(commandEl);
        this.checkParameter(logicValue, mapColElList, tableNameValue);
        TableRowKeyValueColIterateCompare colIterateCompare = new TableRowKeyValueColIterateCompare(tableNameValue, logicValue);
        this.parserMapCols(mapColElList, colIterateCompare);
        return colIterateCompare;
    }

    private void checkParameter(String logicValue, List<Element> mapColElList, String tableNameValue) {
        if (!(StringUtils.isNULLStr((String)logicValue) || LOGIC_OR.equals(logicValue.toUpperCase(Locale.ENGLISH)) || LOGIC_AND.equals(logicValue.toUpperCase(Locale.ENGLISH)))) {
            throw new RuleParseException("illegal logic's value in the tag <TableRowKeyValueColIterateCompare> .");
        }
        if (mapColElList == null || mapColElList.isEmpty()) {
            throw new RuleParseException("Can't find the IncMapCol command tag or DecMapCol command tag in the tag <DiagnoseCommands> .");
        }
        if (tableNameValue != null && "".equals(tableNameValue)) {
            throw new RuleParseException("Can't find table's name in the tag <TableRowKeyValueColIterateCompare> .");
        }
    }

    private void parserMapCols(List<Element> mapColElList, TableRowKeyValueColIterateCompare colIterateCompare) {
        for (Element mapColEl : mapColElList) {
            String tagName = mapColEl.getName();
            if (ELEMENT_INCMAPCOL.equals(tagName)) {
                colIterateCompare.addIncMapCol(this.getKeyName(mapColEl), this.getValueName(mapColEl), this.getOperator(mapColEl));
                continue;
            }
            if (!ELEMENT_DECMAPCOL.equals(tagName)) continue;
            colIterateCompare.addDecMapCol(this.getKeyName(mapColEl), this.getValueName(mapColEl), this.getOperator(mapColEl));
        }
    }

    private String getOperator(Element incMapColEl) {
        String operatorValue = incMapColEl.attributeValue(ATTRIBUTE_OPERATOR);
        if (!(StringUtils.isNULLStr((String)operatorValue) || OPERATOR_IN.equals(operatorValue.toUpperCase(Locale.ENGLISH)) || OPERATOR_NI.equals(operatorValue.toUpperCase(Locale.ENGLISH)))) {
            throw new RuleParseException("illegal operator's value in the tag <TableRowKeyValueColIterateCompare> .");
        }
        return operatorValue;
    }

    private String getValueName(Element incMapColEl) {
        String valueNameValue = incMapColEl.attributeValue(ATTRIBUTE_VALUENAME);
        if (StringUtils.isNULLStr((String)valueNameValue)) {
            throw new RuleParseException("Can't find the IncMapCol command tag or DecMapCol command tag attribute: valueName's Value in the tag <DiagnoseCommands> .");
        }
        return valueNameValue;
    }

    private String getKeyName(Element incMapColEl) {
        String keyNameValue = incMapColEl.attributeValue(ATTRIBUTE_KEYNAME);
        if (StringUtils.isNULLStr((String)keyNameValue)) {
            throw new RuleParseException("Can't find the IncMapCol command tag or DecMapCol command tag attribute: keyName's Value in the tag <DiagnoseCommands> .");
        }
        return keyNameValue;
    }
}

