/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.faulttree.command.parser.diagnose;

import com.huawei.ism.tool.loganalyzer.faulttree.command.diagnose.TableRowMultiColIterateCompare;
import com.huawei.ism.tool.loganalyzer.faulttree.command.enumer.RuleOperator;
import com.huawei.ism.tool.loganalyzer.faulttree.command.templet.DiagnoseCommand;
import com.huawei.ism.tool.loganalyzer.faulttree.command.templet.DiagnoseCommandParser;
import com.huawei.ism.tool.loganalyzer.faulttree.exception.XmlParseException;
import java.util.List;
import java.util.Locale;
import org.dom4j.Element;

public class TableRowMultiColIterateCompareParser
extends DiagnoseCommandParser {
    @Override
    public DiagnoseCommand parse(Element commandEl) {
        try {
            String repeatColName = commandEl.attributeValue("repeatColName");
            if (repeatColName == null) {
                throw new XmlParseException("TableRowSingleColIterateCompare command tag parse failed, repeatColName is null.");
            }
            String keyWords = commandEl.attributeValue("keyWords");
            if (keyWords == null) {
                throw new XmlParseException("TableRowSingleColIterateCompare command tag parse failed, keyWords is null.");
            }
            String fromStr = commandEl.attributeValue("from");
            String toStr = commandEl.attributeValue("to");
            String repeatTimesStr = commandEl.attributeValue("repeatTimes");
            String operator = commandEl.attributeValue("operator");
            RuleOperator ruleOperator = null;
            if (operator != null) {
                ruleOperator = RuleOperator.valueOf(operator.toUpperCase(Locale.ENGLISH));
            }
            if (ruleOperator != RuleOperator.RG) {
                if (repeatTimesStr == null) {
                    throw new XmlParseException("TableRowMultiColIterateCompare diagnose command parse error,repeatTimes is empty.");
                }
            } else if (fromStr == null || toStr == null) {
                throw new XmlParseException("TableRowMultiColIterateCompare diagnose command parse error,from ,to is empty.");
            }
            TableRowMultiColIterateCompare trmcic = new TableRowMultiColIterateCompare(commandEl, ruleOperator);
            List<Element> colValueElList = TableRowMultiColIterateCompareParser.getElementList(commandEl, "ColValue");
            this.addColValue(trmcic, colValueElList);
            return trmcic;
        }
        catch (Exception e) {
            throw new XmlParseException("TableRowMultiColIterateCompare diagnose command parse error,repeatTimes is empty.");
        }
    }

    private void addColValue(TableRowMultiColIterateCompare trmcic, List<Element> colValueElList) {
        for (Element keyValueEl : colValueElList) {
            String key = keyValueEl.attributeValue("colName");
            if (key == null) {
                throw new XmlParseException("KeyValueIterateCompare diagnose command parse error, KeyValue's attr[key] isn't found.");
            }
            String fromStr = keyValueEl.attributeValue("from");
            int from = 0;
            if (fromStr != null) {
                from = Integer.parseInt(fromStr);
            }
            String toStr = keyValueEl.attributeValue("to");
            int to = 0;
            if (toStr != null) {
                to = Integer.parseInt(toStr);
            }
            String operator = keyValueEl.attributeValue("operator");
            RuleOperator ruleOperator = null;
            if (operator != null) {
                ruleOperator = RuleOperator.valueOf(operator.toUpperCase(Locale.ENGLISH));
            }
            trmcic.add(key, keyValueEl.attributeValue("compareValue"), from, to, ruleOperator);
        }
    }
}

