/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.faulttree.configuration.model.cause;

import com.huawei.ism.tool.loganalyzer.faulttree.configuration.cache.RuleCache;
import com.huawei.ism.tool.loganalyzer.faulttree.exception.VersionFormatErrorException;
import com.huawei.ism.tool.loganalyzer.faulttree.expression.LogicExpression;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;

public class Cause {
    private String id;
    private String groupId;
    private LogicExpression logicExpression;
    private List<ModelVersion> includeVersionList = new ArrayList<ModelVersion>();
    private List<ModelVersion> excludeVersionList = new ArrayList<ModelVersion>();

    public Cause(String id) {
        this.id = id;
    }

    public LogicExpression getLogicExpression() {
        return this.logicExpression;
    }

    public void addIncludeVersion(ModelVersion mv) {
        this.includeVersionList.add(mv);
    }

    public void addExcludeVersion(ModelVersion mv) {
        this.excludeVersionList.add(mv);
    }

    public boolean valid(String model, String version) {
        if (this.logicExpression == null) {
            return false;
        }
        for (ModelVersion modelVersion : this.excludeVersionList) {
            if (!modelVersion.containsModel(model) || !modelVersion.validVersion(version)) continue;
            return false;
        }
        if (this.includeVersionList.isEmpty()) {
            return true;
        }
        for (ModelVersion modelVersion : this.includeVersionList) {
            if (!modelVersion.containsModel(model) || !modelVersion.validVersion(version)) continue;
            return true;
        }
        return false;
    }

    public List<ModelVersion> getIncludeVersionList() {
        return this.includeVersionList;
    }

    public String getId() {
        return this.id;
    }

    public void setLogicExpression(String logicExpre, RuleCache ruleCache) {
        this.logicExpression = new LogicExpression(logicExpre, ruleCache);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Cause other = (Cause)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public static final class ModelVersion {
        private static final Pattern RULE_VERSION_PATTERN = Pattern.compile("^V\\d{3}R\\d{3}C\\d{2}(SPCG?[\\dA-Z]+)*(B\\d+)*[Tt]*$");
        private Set<String> modelSet = new HashSet<String>();
        private String from;
        private String to;

        public boolean containsModel(String model) {
            return this.modelSet.contains(model);
        }

        public boolean validVersion(String version) {
            return (version = version.toUpperCase(Locale.ENGLISH).trim().split("B")[0].split("T")[0]).compareTo(this.from) >= 0 && version.compareTo(this.to) <= 0;
        }

        public void setModelList(String modelList) {
            String[] modelArr;
            String[] stringArray = modelArr = modelList.split(",");
            int n = modelArr.length;
            int n2 = 0;
            while (n2 < n) {
                String model = stringArray[n2];
                this.modelSet.add(model);
                ++n2;
            }
        }

        public String getFrom() {
            return this.from;
        }

        public void setFrom(String from) {
            if (!RULE_VERSION_PATTERN.matcher(from = from.toUpperCase(Locale.ENGLISH).trim()).matches()) {
                throw new VersionFormatErrorException("The format of the version is invalid:" + from);
            }
            this.from = from.split("B")[0].split("T")[0];
        }

        public String getTo() {
            return this.to;
        }

        public List<String> getModelList() {
            ArrayList<String> modelList = new ArrayList<String>(this.modelSet);
            Collections.sort(modelList);
            return modelList;
        }

        public void setTo(String to) {
            if (!RULE_VERSION_PATTERN.matcher(to = to.toUpperCase(Locale.ENGLISH).trim()).matches()) {
                throw new VersionFormatErrorException("The format of the version is invalid:" + to);
            }
            this.to = to.split("B")[0].split("T")[0];
        }
    }
}

