/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.faulttree.configuration.model.rule;

import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.loganalyzer.faulttree.command.templet.DiagnoseCommand;
import com.huawei.ism.tool.loganalyzer.faulttree.command.templet.MatchCommand;
import com.huawei.ism.tool.loganalyzer.faulttree.command.templet.ObjectCommand;
import com.huawei.ism.tool.loganalyzer.faulttree.configuration.model.rule.DiagnoseCommands;
import com.huawei.ism.tool.loganalyzer.faulttree.datasource.model.Type;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class Rule {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(Rule.class);
    private List<String> sourceTypeList = new ArrayList<String>();
    private String id;
    private List<MatchCommand> matchCommandList = new ArrayList<MatchCommand>();
    private List<ObjectCommand> objectCommandList = new ArrayList<ObjectCommand>();
    private DiagnoseCommands diagnoseCommands = new DiagnoseCommands();

    public Rule() {
    }

    public Rule(String sourceType, String id) {
        String[] sts;
        String[] stringArray = sts = sourceType.split(",");
        int n = sts.length;
        int n2 = 0;
        while (n2 < n) {
            String st = stringArray[n2];
            Type.valid(st);
            this.sourceTypeList.add(st);
            ++n2;
        }
        this.id = id;
    }

    public void addMatchCommand(MatchCommand matchCommand) {
        this.matchCommandList.add(matchCommand);
    }

    public void addObjectCommand(ObjectCommand objectCommand) {
        this.objectCommandList.add(objectCommand);
    }

    public void addDiagnoseCommand(DiagnoseCommand diagnoseCommand) {
        this.diagnoseCommands.addDiagnoseCommand(diagnoseCommand);
    }

    public String getId() {
        return this.id;
    }

    public List<String> getSourceTypeList() {
        return this.sourceTypeList;
    }

    public List<MatchCommand> getMatchCommandList() {
        return this.matchCommandList;
    }

    public List<ObjectCommand> getObjectCommandList() {
        return this.objectCommandList;
    }

    public DiagnoseCommands getDiagnoseCommands() {
        return this.diagnoseCommands;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Rule other = (Rule)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return "Rule [sourceTypeList=" + this.sourceTypeList + ", id=" + this.id + "]";
    }
}

