/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.faulttree.configuration.model.version;

import com.huawei.ism.tool.loganalyzer.faulttree.configuration.model.version.Version;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class Model
implements Comparable<Model> {
    private String name;
    private Set<String> matchNameSet = new HashSet<String>();
    private Map<String, Version> versionMap = new HashMap<String, Version>();

    public Model(String name) {
        this.name = name.trim();
    }

    public void setMatchName(String matchName) {
        String[] names;
        String[] stringArray = names = matchName.split(",");
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String na = stringArray[n2];
            this.matchNameSet.add(na.trim());
            ++n2;
        }
    }

    public void addVersion(Version version) {
        this.versionMap.put(version.getValue(), version);
    }

    public boolean validModel(String modelName) {
        return this.matchNameSet.contains(modelName.trim());
    }

    public boolean validVersion(String versionName) {
        return this.versionMap.containsKey(versionName.trim().toUpperCase(Locale.ENGLISH).split("SPC")[0].split("SPH")[0].split("T")[0].split("B")[0]);
    }

    public Version get(String version) {
        return this.versionMap.get(version.trim().toUpperCase(Locale.ENGLISH).split("SPC")[0].split("SPH")[0].split("T")[0].split("B")[0]);
    }

    public List<Version> getVersionList() {
        ArrayList<Version> vl = new ArrayList<Version>(this.versionMap.values());
        Collections.sort(vl);
        return vl;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public int compareTo(Model model) {
        return this.name.compareTo(model.name);
    }

    public Set<String> getMatchNameSet() {
        return this.matchNameSet;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Model other = (Model)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

