/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.faulttree.configuration.parser;

import com.huawei.ism.tool.loganalyzer.faulttree.configuration.model.cause.Cause;
import com.huawei.ism.tool.loganalyzer.faulttree.configuration.model.cause.CauseGroup;
import com.huawei.ism.tool.loganalyzer.faulttree.configuration.model.cause.CauseGroupList;
import com.huawei.ism.tool.loganalyzer.faulttree.configuration.model.pheno.Pheno;
import com.huawei.ism.tool.loganalyzer.faulttree.exception.PhenoNotFoundException;
import com.huawei.ism.tool.loganalyzer.faulttree.model.DeviceType;
import com.huawei.ism.tool.loganalyzer.faulttree.util.Dom4jParser;
import java.io.File;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;

public class CauseParser
extends Dom4jParser {
    public static void parseCauseFile(File file, DeviceType storageDeviceType) {
        Document doc = CauseParser.getDocument(file);
        Element causeGroupListEl = doc.getRootElement();
        String phenoId = causeGroupListEl.attributeValue("phenoId");
        Pheno pheno = storageDeviceType.faultTypeCache().getPheno(phenoId);
        if (pheno == null) {
            throw new PhenoNotFoundException("Can't find the pheno by phenoId:" + phenoId);
        }
        CauseGroupList causeGroupList = new CauseGroupList(pheno);
        List<Element> causeGroupElList = CauseParser.getElementList(causeGroupListEl, "CauseGroup");
        for (Element causeGroupEl : causeGroupElList) {
            CauseGroup causeGroup = new CauseGroup(causeGroupEl.attributeValue("id"));
            CauseParser.parseCauseGroupEl(causeGroupEl, causeGroup, storageDeviceType);
            causeGroupList.addCauseGroup(causeGroup);
        }
        storageDeviceType.causeGroupCache().add(causeGroupList);
    }

    private static void parseCauseGroupEl(Element causeGroupEl, CauseGroup causeGroup, DeviceType storageDeviceType) {
        List<Element> causeElList = CauseParser.getElementList(causeGroupEl, "Cause");
        for (Element causeEl : causeElList) {
            Cause cause = new Cause(causeEl.attributeValue("id"));
            cause.setGroupId(causeGroup.getId());
            cause.setLogicExpression(causeEl.attributeValue("logicExpression"), storageDeviceType.ruleCache());
            CauseParser.parseExcludeVersion(causeEl, cause);
            CauseParser.parseIncludeVersion(causeEl, cause);
            causeGroup.add(cause);
        }
    }

    private static void parseIncludeVersion(Element causeEl, Cause cause) {
        List<Element> includeVersionElList = CauseParser.getElementList(causeEl, "IncludeVersion");
        for (Element includeVersionEl : includeVersionElList) {
            Cause.ModelVersion mv = new Cause.ModelVersion();
            mv.setModelList(includeVersionEl.attributeValue("modelList"));
            mv.setFrom(includeVersionEl.attributeValue("from"));
            mv.setTo(includeVersionEl.attributeValue("to"));
            cause.addIncludeVersion(mv);
        }
    }

    private static void parseExcludeVersion(Element causeEl, Cause cause) {
        List<Element> excludeVersionElList = CauseParser.getElementList(causeEl, "ExcludeVersion");
        for (Element excludeVersionEl : excludeVersionElList) {
            Cause.ModelVersion mv = new Cause.ModelVersion();
            mv.setModelList(excludeVersionEl.attributeValue("modelList"));
            mv.setFrom(excludeVersionEl.attributeValue("from"));
            mv.setTo(excludeVersionEl.attributeValue("to"));
            cause.addExcludeVersion(mv);
        }
    }
}

