/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.faulttree.configuration.parser;

import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.loganalyzer.faulttree.command.parser.register.DiagnoseCommandParserMap;
import com.huawei.ism.tool.loganalyzer.faulttree.command.parser.register.MatchCommandParserMap;
import com.huawei.ism.tool.loganalyzer.faulttree.command.parser.register.ObjectCommandParserMap;
import com.huawei.ism.tool.loganalyzer.faulttree.command.templet.DiagnoseCommandParser;
import com.huawei.ism.tool.loganalyzer.faulttree.command.templet.MatchCommandParser;
import com.huawei.ism.tool.loganalyzer.faulttree.command.templet.ObjectCommandParser;
import com.huawei.ism.tool.loganalyzer.faulttree.configuration.model.rule.Rule;
import com.huawei.ism.tool.loganalyzer.faulttree.datematch.DateMatcherCache;
import com.huawei.ism.tool.loganalyzer.faulttree.exception.IllegalCommandException;
import com.huawei.ism.tool.loganalyzer.faulttree.exception.RuleParseException;
import com.huawei.ism.tool.loganalyzer.faulttree.exception.RuleXmlFileIllegalException;
import com.huawei.ism.tool.loganalyzer.faulttree.model.DeviceType;
import com.huawei.ism.tool.loganalyzer.faulttree.util.Dom4jParser;
import java.io.File;
import java.util.List;
import java.util.Locale;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.slf4j.Logger;

public class RuleParser
extends Dom4jParser {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(RuleParser.class);

    public static void parse(DeviceType storageDeviceType) {
        File ruleRootDir = new File(String.valueOf(storageDeviceType.getConfPath()) + File.separator + "rules");
        RuleParser.parse(ruleRootDir, storageDeviceType);
    }

    private static void parse(File ruleRootDir, DeviceType storageDeviceType) {
        File[] files = ruleRootDir.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    RuleParser.parse(file, storageDeviceType);
                } else if (file.getName().toLowerCase(Locale.ENGLISH).endsWith(".xml")) {
                    RuleParser.parseRuleFile(file, storageDeviceType);
                }
                ++n2;
            }
        }
    }

    private static void parseRuleFile(File xmlFile, DeviceType storageDeviceType) {
        try {
            Document doc = RuleParser.getDocument(xmlFile);
            Element rootEl = doc.getRootElement();
            Attribute sourceTypeAttribute = rootEl.attribute("sourceType");
            if (!rootEl.getName().equals("RuleList") || sourceTypeAttribute == null) {
                throw new RuleXmlFileIllegalException("The content of Rule file is illegal: " + xmlFile.getAbsolutePath());
            }
            String sourceType = sourceTypeAttribute.getValue();
            List<Element> ruleElList = RuleParser.getElementList(rootEl, "Rule");
            for (Element ruleEl : ruleElList) {
                Rule rule = new Rule(sourceType, ruleEl.attributeValue("id"));
                "syslog_0236".equals(rule.getId());
                RuleParser.parseMatchCommand(ruleEl, rule, storageDeviceType.dateMatcherCache());
                RuleParser.parseObjectCommand(ruleEl, rule);
                RuleParser.parseDiagnoseCommand(ruleEl, rule);
                storageDeviceType.ruleCache().add(rule);
            }
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(RuleParser.class).error("parseRuleFile is error:", (Throwable)e);
        }
    }

    private static void parseDiagnoseCommand(Element ruleEl, Rule rule) {
        Element diagnoseCommandsEl = ruleEl.element("DiagnoseCommands");
        if (diagnoseCommandsEl != null) {
            List<Element> diagnoseCommandElList = RuleParser.getElementList(diagnoseCommandsEl);
            if (diagnoseCommandElList.isEmpty()) {
                throw new RuleParseException("Can't find the sub command tag in the tag <DiagnoseCommands>, ruleId:" + rule.getId());
            }
            String logic = diagnoseCommandsEl.attributeValue("logic");
            if (logic != null) {
                rule.getDiagnoseCommands().setLogic(logic);
            }
            for (Element diagnoseCommandEl : diagnoseCommandElList) {
                DiagnoseCommandParser parser = DiagnoseCommandParserMap.get(diagnoseCommandEl.getName());
                if (parser == null) {
                    throw new IllegalCommandException("Illegal Command tag name in <DiagnoseCommands>:" + diagnoseCommandEl.getName());
                }
                rule.addDiagnoseCommand(parser.parse(diagnoseCommandEl));
            }
        }
    }

    private static void parseObjectCommand(Element ruleEl, Rule rule) {
        Element faultObjectCommandsEl = ruleEl.element("FaultObjectCommands");
        if (faultObjectCommandsEl != null) {
            List<Element> faultObjectCommandElList = RuleParser.getElementList(faultObjectCommandsEl);
            if (faultObjectCommandElList.isEmpty()) {
                throw new RuleParseException("Can't find the sub command tag in the tag <FaultObjectCommands>, ruleId:" + rule.getId());
            }
            for (Element faultObjectCommandEl : faultObjectCommandElList) {
                ObjectCommandParser parser = ObjectCommandParserMap.get(faultObjectCommandEl.getName());
                if (parser == null) {
                    throw new IllegalCommandException("Illegal Command tag name in <FaultObjectCommands>:" + faultObjectCommandEl.getName());
                }
                rule.addObjectCommand(parser.parse(faultObjectCommandEl));
            }
        }
    }

    private static void parseMatchCommand(Element ruleEl, Rule rule, DateMatcherCache cache) {
        Element matchCommandsEl = ruleEl.element("MatchCommands");
        if (matchCommandsEl == null) {
            throw new RuleParseException("MatchCommands tag not found in rule config tag, ruleId:" + rule.getId());
        }
        List<Element> matchCommandElList = RuleParser.getElementList(matchCommandsEl);
        if (matchCommandElList.isEmpty()) {
            throw new RuleParseException("Can't find the sub command tag in the tag <MatchCommands>, ruleId:" + rule.getId());
        }
        for (Element matchCommandEl : matchCommandElList) {
            MatchCommandParser parser = MatchCommandParserMap.get(matchCommandEl.getName());
            if (parser == null) {
                throw new IllegalCommandException("Illegal Command tag name in <MatchCommands>:" + matchCommandEl.getName());
            }
            rule.addMatchCommand(parser.parse(matchCommandEl, cache));
        }
    }
}

