/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.faulttree.datasource.matcher;

import com.huawei.ism.tool.loganalyzer.faulttree.datasource.matcher.FileMatcher;
import com.huawei.ism.tool.loganalyzer.faulttree.exception.RegexCompileException;
import com.huawei.ism.tool.loganalyzer.faulttree.util.FileUtil;
import com.huawei.ism.tool.loganalyzer.faulttree.util.MatcherUtils;
import java.io.File;
import java.util.Locale;
import java.util.regex.Pattern;

public class DirPathMatcher
extends FileMatcher {
    public DirPathMatcher(String matchRegex) {
        try {
            if (!matchRegex.startsWith(File.separator)) {
                matchRegex = "(/|\\\\)" + matchRegex;
            }
            if (!matchRegex.endsWith(File.separator)) {
                matchRegex = String.valueOf(matchRegex) + "(/|\\\\)";
            }
            this.matchPattern = Pattern.compile(matchRegex);
        }
        catch (Exception e) {
            throw new RegexCompileException("DirPathMatcher.matchRegex or separatorRegex is wrong, please check.", e);
        }
    }

    @Override
    public boolean isMatch(File file, int indexStart) {
        String parentFilePath = FileUtil.getFilePath(file.getParentFile());
        return MatcherUtils.isMatch(parentFilePath.substring(indexStart).toLowerCase(Locale.ENGLISH), this.matchPattern);
    }
}

