/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.faulttree.datasource.model;

import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.loganalyzer.faulttree.datasource.cache.FileCategorizerCache;
import com.huawei.ism.tool.loganalyzer.faulttree.datasource.model.FileAnalyzer;
import com.huawei.ism.tool.loganalyzer.faulttree.datasource.model.FileCategorizer;
import com.huawei.ism.tool.loganalyzer.faulttree.datasource.model.SourceType;
import com.huawei.ism.tool.loganalyzer.faulttree.datasource.model.Type;
import com.huawei.ism.tool.loganalyzer.faulttree.util.FileUtil;
import java.io.File;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;

public class DataSource {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(DataSource.class);
    private Map<Type, SourceType> sourceMap = new HashMap<Type, SourceType>();
    private FileCategorizerCache fileCategorizerCache;
    private int pkgRootDirLength;

    public DataSource(File pkgRootDir, FileCategorizerCache fileCategorizerCache) {
        this.pkgRootDirLength = FileUtil.getFilePath(pkgRootDir).length();
        this.fileCategorizerCache = fileCategorizerCache;
        this.classify(pkgRootDir);
    }

    public SourceType getSourceType(Type type) {
        return this.sourceMap.get((Object)type);
    }

    public void destroy() {
        for (SourceType t : this.sourceMap.values()) {
            t.destroy();
        }
        this.sourceMap.clear();
    }

    public void add(FileAnalyzer fileInfo, Type type) {
        SourceType sourceType = this.getSourceType(type);
        if (sourceType == null) {
            sourceType = new SourceType(type);
            this.sourceMap.put(sourceType.getType(), sourceType);
        }
        sourceType.add(fileInfo);
    }

    private void classify(File pkgRootDir) {
        File[] files = pkgRootDir.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (!file.isHidden()) {
                    if (file.isFile()) {
                        String fileName = file.getName().toLowerCase(Locale.ENGLISH);
                        if (!(fileName.endsWith(".tgz") || fileName.endsWith(".tar") || fileName.endsWith(".tar.gz") || fileName.endsWith(".zip") || fileName.endsWith(".7z") || fileName.endsWith(".rar") || fileName.endsWith(".bz2"))) {
                            for (FileCategorizer fileCategorizer : this.fileCategorizerCache.getFileCategorizerCollection()) {
                                fileCategorizer.classify(this, file, this.pkgRootDirLength);
                            }
                        }
                    } else {
                        this.classify(file);
                    }
                }
                ++n2;
            }
        }
    }
}

