/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.faulttree.datasource.model;

import com.huawei.ism.tool.loganalyzer.faulttree.datasource.interfaces.IFileContentProcessor;
import com.huawei.ism.tool.loganalyzer.faulttree.datasource.interfaces.IRecordContentProcessor;
import com.huawei.ism.tool.loganalyzer.faulttree.exception.FileContentProcessException;
import com.huawei.ism.tool.loganalyzer.faulttree.exception.RecordContentProcessException;
import com.huawei.ism.tool.loganalyzer.faulttree.model.DeviceType;
import com.huawei.ism.tool.loganalyzer.faulttree.util.IOUtils;
import com.huawei.ism.tool.loganalyzer.faulttree.util.MatcherUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.regex.Pattern;

public class FileAnalyzer {
    private static final int BUFFER_SIZE = 0x200000;
    private static final int MAX_LINE_LENGTH_TO_SKIP = 2000;
    private File file;
    private List<Pattern> separatorPatternList;

    public FileAnalyzer(File file, List<Pattern> separatorPatternList) {
        this.file = file;
        this.separatorPatternList = separatorPatternList;
    }

    public File getFile() {
        return this.file;
    }

    private boolean match(CharSequence lineContent) {
        if (lineContent.length() > 2000) {
            return false;
        }
        for (Pattern pattern : this.separatorPatternList) {
            if (!MatcherUtils.isMatch(lineContent, pattern)) continue;
            return true;
        }
        return false;
    }

    public void analyse(IRecordContentProcessor recordContentProcessor, DeviceType deviceType) {
        BufferedReader bufferedReader = null;
        try {
            try {
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file), "utf-8"), 0x200000);
                StringBuilder recordContent = new StringBuilder();
                String lineContent = null;
                int lineNumber = 0;
                while ((lineContent = bufferedReader.readLine()) != null) {
                    if (this.match(lineContent) && recordContent.length() > 0) {
                        recordContentProcessor.process(recordContent, lineNumber, this.file, deviceType);
                        recordContent = new StringBuilder(500);
                        ++lineNumber;
                    }
                    recordContent.append(lineContent).append('\n');
                }
                recordContentProcessor.process(recordContent, lineNumber, this.file, deviceType);
            }
            catch (IOException e) {
                throw new RecordContentProcessException("An exception occored while processing record-ontent: ", e);
            }
        }
        catch (Throwable throwable) {
            IOUtils.close(bufferedReader);
            throw throwable;
        }
        IOUtils.close((Closeable)bufferedReader);
    }

    public void analyse(IFileContentProcessor fileContentProcessor) {
        FileInputStream fis = null;
        InputStreamReader isr = null;
        BufferedReader bufferedReader = null;
        try {
            try {
                fis = new FileInputStream(this.file);
                isr = new InputStreamReader((InputStream)fis, "utf-8");
                bufferedReader = new BufferedReader(isr, 0x200000);
                StringBuilder recordContent = new StringBuilder();
                String lineContent = null;
                while ((lineContent = bufferedReader.readLine()) != null) {
                    recordContent.append(lineContent).append('\n');
                }
                fileContentProcessor.process(recordContent);
            }
            catch (IOException e) {
                throw new FileContentProcessException("An exception occored while processing file-ontent: ", e);
            }
        }
        catch (Throwable throwable) {
            IOUtils.close(bufferedReader);
            IOUtils.close(isr);
            IOUtils.close((Closeable)fis);
            throw throwable;
        }
        IOUtils.close((Closeable)bufferedReader);
        IOUtils.close((Closeable)isr);
        IOUtils.close((Closeable)fis);
    }
}

