/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.faulttree.datasource.model;

import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.loganalyzer.faulttree.datasource.matcher.FileMatcher;
import com.huawei.ism.tool.loganalyzer.faulttree.datasource.model.DataSource;
import com.huawei.ism.tool.loganalyzer.faulttree.datasource.model.FileAnalyzer;
import com.huawei.ism.tool.loganalyzer.faulttree.datasource.model.Type;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class FileCategorizer {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(DataSource.class);
    private Type type;
    private List<FileMatcher> excludedMatcherList = new ArrayList<FileMatcher>(5);
    private List<FileMatcher> includeMatcherList = new ArrayList<FileMatcher>(5);

    public FileCategorizer(Type type) {
        this.type = type;
    }

    public void addExcludedMatcher(FileMatcher matcher) {
        this.excludedMatcherList.add(matcher);
    }

    public void addIncludeMatcher(FileMatcher matcher) {
        this.includeMatcherList.add(matcher);
    }

    private boolean isExclude(File file, int indexStart) {
        for (FileMatcher fileMatcher : this.excludedMatcherList) {
            if (!fileMatcher.isMatch(file, indexStart)) continue;
            return true;
        }
        return false;
    }

    public void classify(DataSource dataSource, File file, int indexStart) {
        if (this.isExclude(file, indexStart)) {
            return;
        }
        for (FileMatcher matcher : this.includeMatcherList) {
            if (!matcher.isMatch(file, indexStart)) continue;
            dataSource.add(new FileAnalyzer(file, matcher.getSeparatorPatternList()), this.type);
            return;
        }
    }

    public Type getType() {
        return this.type;
    }
}

