/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.faulttree.datasource.model;

import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.loganalyzer.faulttree.datasource.interfaces.IFileContentProcessor;
import com.huawei.ism.tool.loganalyzer.faulttree.datasource.model.FileAnalyzer;
import com.huawei.ism.tool.loganalyzer.faulttree.datasource.model.Type;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class SourceType {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(SourceType.class);
    private Type type;
    private List<FileAnalyzer> fileAnalyzerList = new ArrayList<FileAnalyzer>();

    public SourceType(Type type) {
        this.type = type;
    }

    public void add(FileAnalyzer fileAnalyzer) {
        this.fileAnalyzerList.add(fileAnalyzer);
    }

    public Type getType() {
        return this.type;
    }

    public List<FileAnalyzer> getFileAnalyzerList() {
        return this.fileAnalyzerList;
    }

    public List<File> getFileList() {
        ArrayList<File> fileList = new ArrayList<File>();
        for (FileAnalyzer fileAnalyzer : this.fileAnalyzerList) {
            fileList.add(fileAnalyzer.getFile());
        }
        return fileList;
    }

    public void eachFile(IFileContentProcessor fileContentProcessor) {
        for (FileAnalyzer fileAnalyzer : this.fileAnalyzerList) {
            try {
                fileAnalyzer.analyse(fileContentProcessor);
            }
            catch (Exception e) {
                LOGGER.error("SourceType.analyseEachFile(IFileContentProcessor fileContentProcessor) error:", (Throwable)e);
            }
        }
    }

    public void destroy() {
        this.fileAnalyzerList.clear();
    }
}

