/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.faulttree.datasource.model;

import com.huawei.ism.tool.loganalyzer.faulttree.exception.DataSourceException;
import java.util.HashMap;
import java.util.Map;

public enum Type {
    CONFIG("config", "info.analyze.faultTree.progress.checkconfig"),
    MAIN_MMLINFO("main_mmlinfo", "info.analyze.faultTree.progress.checkconfig"),
    DIAGNOSE("diagnose", "info.analyze.faultTree.progress.checkdiagnose"),
    DIAGNOSE_01("diagnose_01", "info.analyze.faultTree.progress.checkdiagnose"),
    SYSLOG("syslog", "info.analyze.faultTree.progress.checksyslog"),
    EVENT("event", "info.analyze.faultTree.progress.checkevent"),
    BOMCODE("bomcode", "info.analyze.faultTree.progress.checkbomcode");

    public static final Map<String, Type> MAP;
    private String name = null;
    private String desc = null;

    static {
        MAP = new HashMap<String, Type>();
        Type[] typeArray = Type.values();
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Type t = typeArray[n2];
            MAP.put(t.name, t);
            ++n2;
        }
    }

    private Type(String name, String desc) {
        this.name = name;
        this.desc = desc;
    }

    public static final Type transfer(String type) {
        return MAP.get(type);
    }

    public static void valid(String type) {
        if (!MAP.containsKey(type)) {
            throw new DataSourceException("Data source is undefined:" + type);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDesc() {
        return this.desc;
    }
}

