/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.faulttree.datasource.parser;

import com.huawei.ism.tool.loganalyzer.faulttree.datasource.matcher.DirPathMatcher;
import com.huawei.ism.tool.loganalyzer.faulttree.datasource.matcher.FileMatcher;
import com.huawei.ism.tool.loganalyzer.faulttree.datasource.matcher.FileNameMatcher;
import com.huawei.ism.tool.loganalyzer.faulttree.datasource.matcher.FilePathMatcher;
import com.huawei.ism.tool.loganalyzer.faulttree.datasource.model.FileCategorizer;
import com.huawei.ism.tool.loganalyzer.faulttree.datasource.model.Type;
import com.huawei.ism.tool.loganalyzer.faulttree.model.DeviceType;
import com.huawei.ism.tool.loganalyzer.faulttree.util.Dom4jParser;
import java.io.File;
import java.util.List;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;

public class DataSourceParser
extends Dom4jParser {
    private static final Logger LOGGER = Logger.getLogger(DataSourceParser.class);

    public static void parse(DeviceType storageDeviceType) {
        LOGGER.info((Object)("parse datasource path:" + storageDeviceType.getConfPath()));
        Document doc = DataSourceParser.getDocument(new File(String.valueOf(storageDeviceType.getConfPath()) + File.separator + "faulttree-datasource.xml"));
        Element rootEl = doc.getRootElement();
        List<Element> sourceTypeElList = DataSourceParser.getElementList(rootEl, "SourceType");
        for (Element sourceTypeEl : sourceTypeElList) {
            storageDeviceType.fileCategorizerCache().add(DataSourceParser.parse(sourceTypeEl));
        }
    }

    private static FileCategorizer parse(Element sourceTypeEl) {
        Element includeEl;
        String sourceTypeName = sourceTypeEl.attributeValue("name");
        Type.valid(sourceTypeName);
        FileCategorizer fileCategorizer = new FileCategorizer(Type.transfer(sourceTypeName));
        Element excludedEl = sourceTypeEl.element("Exclude");
        if (excludedEl != null) {
            DataSourceParser.parseExcludedEl(fileCategorizer, excludedEl);
        }
        if ((includeEl = sourceTypeEl.element("Include")) != null) {
            DataSourceParser.parseIncludeEl(fileCategorizer, includeEl);
        }
        return fileCategorizer;
    }

    private static void parseExcludedEl(FileCategorizer fileCategorizer, Element excludedEl) {
        List<Element> mactherElList = DataSourceParser.getElementList(excludedEl);
        for (Element mactherEl : mactherElList) {
            FileMatcher matcher = DataSourceParser.parseMatcher(mactherEl);
            if (matcher == null) continue;
            fileCategorizer.addExcludedMatcher(matcher);
        }
    }

    private static void parseIncludeEl(FileCategorizer fileCategorizer, Element includeEl) {
        List<Element> mactherElList = DataSourceParser.getElementList(includeEl);
        for (Element mactherEl : mactherElList) {
            FileMatcher matcher = DataSourceParser.parseMatcher(mactherEl);
            if (matcher == null) continue;
            fileCategorizer.addIncludeMatcher(matcher);
        }
    }

    private static FileMatcher parseMatcher(Element mactherEl) {
        FileMatcher matcher = null;
        if ("MatchFilePath".equals(mactherEl.getName())) {
            matcher = new FilePathMatcher(mactherEl.attributeValue("value"));
            DataSourceParser.parseSeparator(mactherEl, matcher);
        } else if ("MatchDirPath".equals(mactherEl.getName())) {
            matcher = new DirPathMatcher(mactherEl.attributeValue("value"));
            DataSourceParser.parseSeparator(mactherEl, matcher);
        } else if ("MatchFileName".equals(mactherEl.getName())) {
            matcher = new FileNameMatcher(mactherEl.attributeValue("value"));
            DataSourceParser.parseSeparator(mactherEl, matcher);
        }
        return matcher;
    }

    private static void parseSeparator(Element mactherEl, FileMatcher matcher) {
        List<Element> separatorElList = DataSourceParser.getElementList(mactherEl, "Separator");
        for (Element separatorEl : separatorElList) {
            matcher.addSeparatorPattern(separatorEl.attributeValue("value"));
        }
    }
}

