/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.faulttree.datematch;

import com.huawei.ism.tool.loganalyzer.faulttree.command.model.DateInfo;
import com.huawei.ism.tool.loganalyzer.faulttree.util.MatcherUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DateMatcher {
    private String id;
    private Pattern pattern;
    private Pattern matchPattern;
    private SimpleDateFormat format;
    private SimpleDateFormat destFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public DateMatcher(String id, String format, String pattern, String matchPattern) {
        this.id = id;
        if (pattern != null) {
            this.pattern = Pattern.compile(pattern);
        }
        if (matchPattern != null) {
            this.matchPattern = Pattern.compile(matchPattern);
        }
        this.format = new SimpleDateFormat(format);
    }

    public DateInfo getDateInfo(CharSequence lineContent) {
        Matcher m = null;
        if (this.matchPattern != null && (m = MatcherUtils.match(lineContent, this.matchPattern)) == null) {
            return null;
        }
        if ((m = m != null ? MatcherUtils.match(m.group(), this.pattern) : MatcherUtils.match(lineContent, this.pattern)) == null) {
            return null;
        }
        String dateStr = m.group();
        return this.parseDate(dateStr);
    }

    private synchronized DateInfo parseDate(String dateStr) {
        try {
            Date d = this.format.parse(dateStr);
            return new DateInfo(this.destFormat.format(d), d.getTime());
        }
        catch (ParseException e) {
            return new DateInfo(dateStr, 0L);
        }
    }

    public String getId() {
        return this.id;
    }
}

