/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.faulttree.decompress.decompressor;

import com.huawei.ism.tool.loganalyzer.faulttree.decompress.decompressor.Decompressor;
import com.huawei.ism.tool.loganalyzer.faulttree.decompress.model.DecompressResult;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipDecompressor
extends Decompressor {
    public static final String OLD_PZ_STRING = "OceanspaceS5000T";
    public static final String NEW_PZ_STRING = "Log_info@storage";
    private static final Logger LOGGER = LoggerFactory.getLogger(ZipDecompressor.class);

    public ZipDecompressor(File file) {
        this.file = file;
    }

    public ZipDecompressor(File file, String password) {
        this.file = file;
        this.password = password;
    }

    @Override
    public void decompress(File outPutPath) {
        this.setPassword(OLD_PZ_STRING);
        super.decompress(outPutPath);
        DecompressResult dr = this.getDecompressResult();
        if (dr.getInfo().contains("Wrong password") || dr.getErrorInfo().contains("Wrong password")) {
            this.setPassword(NEW_PZ_STRING);
            super.decompress(outPutPath);
            dr = this.getDecompressResult();
            if (dr.getInfo().contains("Wrong password") || dr.getErrorInfo().contains("Wrong password")) {
                LOGGER.error("decompress error,password is wrong.file:" + this.file.getName());
            }
        }
    }
}

