/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.faulttree.decompress.enumer;

import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.loganalyzer.faulttree.decompress.decompressor.Bz2Decompressor;
import com.huawei.ism.tool.loganalyzer.faulttree.decompress.decompressor.Decompressor;
import com.huawei.ism.tool.loganalyzer.faulttree.decompress.decompressor.SevenZDecompressor;
import com.huawei.ism.tool.loganalyzer.faulttree.decompress.decompressor.TarDecompressor;
import com.huawei.ism.tool.loganalyzer.faulttree.decompress.decompressor.TgzDecompressor;
import com.huawei.ism.tool.loganalyzer.faulttree.decompress.decompressor.ZipDecompressor;
import com.huawei.ism.tool.loganalyzer.util.IOUtil;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;

public enum CompressedFileType {
    SEVENZ(930790575, SevenZDecompressor.class),
    BZ2(1113221177, Bz2Decompressor.class),
    GZ(529205248, TgzDecompressor.class),
    TGZ(529205256, TgzDecompressor.class),
    TAR(1131376230, TarDecompressor.class),
    TAR1(774861424, TarDecompressor.class),
    TAR2(1668440435, TarDecompressor.class),
    TAR3(774859887, TarDecompressor.class),
    ZIP(1347093252, ZipDecompressor.class),
    ZIP2(1347093766, ZipDecompressor.class);

    private static final Set<String> COMPRESSEDFILETYPESET;
    private static final Map<Integer, Constructor<? extends Decompressor>> DECOMPRESSORCONSTRUCTORMAP;
    private int value;
    private Constructor<? extends Decompressor> decompressorConstructor;

    static {
        COMPRESSEDFILETYPESET = new HashSet<String>();
        DECOMPRESSORCONSTRUCTORMAP = new HashMap<Integer, Constructor<? extends Decompressor>>();
        CompressedFileType[] compressedFileTypeArray = CompressedFileType.values();
        int n = compressedFileTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            CompressedFileType t = compressedFileTypeArray[n2];
            DECOMPRESSORCONSTRUCTORMAP.put(t.value, t.decompressorConstructor);
            ++n2;
        }
        COMPRESSEDFILETYPESET.add(".7z");
        COMPRESSEDFILETYPESET.add(".bz2");
        COMPRESSEDFILETYPESET.add(".gz");
        COMPRESSEDFILETYPESET.add(".tgz");
        COMPRESSEDFILETYPESET.add(".rar");
        COMPRESSEDFILETYPESET.add(".tar.gz");
        COMPRESSEDFILETYPESET.add(".tar");
        COMPRESSEDFILETYPESET.add(".zip");
    }

    private CompressedFileType(int value, Class<? extends Decompressor> ecompressorClass) {
        this.value = value;
        try {
            this.decompressorConstructor = ecompressorClass.getConstructor(File.class);
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(CompressedFileType.class).debug("DecompressorConstructor is error:", (Throwable)e);
        }
    }

    public int getValue() {
        return this.value;
    }

    public static boolean validSuffixName(File file) {
        return CompressedFileType.validSuffixName(file.getName());
    }

    public static boolean validSuffixName(String fileName) {
        int dotIndex = fileName.lastIndexOf(46);
        if (dotIndex == -1) {
            return false;
        }
        String suffix = fileName.substring(dotIndex, fileName.length());
        return COMPRESSEDFILETYPESET.contains(suffix);
    }

    public static Decompressor getDecompressor(File file) {
        if (CompressedFileType.validSuffixName(file)) {
            int head;
            block5: {
                head = CompressedFileType.getFileHeader(file);
                if (head != 0) break block5;
                return null;
            }
            try {
                Constructor<? extends Decompressor> decompressorConstructor = DECOMPRESSORCONSTRUCTORMAP.get(head);
                if (decompressorConstructor != null) {
                    return decompressorConstructor.newInstance(file);
                }
                return CompressedFileType.TAR.decompressorConstructor.newInstance(file);
            }
            catch (Exception e) {
                ToolLoggerFactory.getLogger(CompressedFileType.class).debug("GetDecompressor is error:", (Throwable)e);
            }
        }
        return null;
    }

    private static int getFileHeader(File file) throws IOException {
        int value;
        block6: {
            Logger logger = ToolLoggerFactory.getLogger(CompressedFileType.class);
            if (file.length() < 4L) {
                return 0;
            }
            FileInputStream fis = null;
            DataInputStream in = null;
            value = 0;
            try {
                try {
                    fis = new FileInputStream(file);
                    in = new DataInputStream(fis);
                    value = in.readInt();
                }
                catch (Exception e) {
                    logger.debug("getFileHeader is error:", (Throwable)e);
                    IOUtil.close(in);
                    IOUtil.close((Closeable)fis);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(in);
                IOUtil.close((Closeable)fis);
                throw throwable;
            }
            IOUtil.close((Closeable)in);
            IOUtil.close((Closeable)fis);
        }
        return value;
    }
}

