/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.faulttree.decompress.threadpool;

import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.loganalyzer.exception.StopImportException;
import com.huawei.ism.tool.loganalyzer.faulttree.decompress.decompressor.Decompressor;
import com.huawei.ism.tool.loganalyzer.faulttree.decompress.decompressor.ProcessExitException;
import com.huawei.ism.tool.loganalyzer.faulttree.decompress.threadpool.DecompressCallable;
import com.huawei.ism.tool.loganalyzer.faulttree.exception.DiskNotEnoughException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;

public class DecompressThreadPool {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(DecompressThreadPool.class);
    private volatile ExecutorService decompressService;

    public DecompressThreadPool() {
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        availableProcessors = availableProcessors == 0 ? 1 : availableProcessors;
        this.decompressService = Executors.newFixedThreadPool(availableProcessors);
    }

    /*
     * WARNING - void declaration
     */
    public final void execute(List<Decompressor> decompressorList) {
        int size = decompressorList.size();
        int batchCount = size / 4;
        ArrayList<Future<Boolean>> futureList = new ArrayList<Future<Boolean>>();
        if (batchCount == 0) {
            futureList.add(this.decompressService.submit(new DecompressCallable(decompressorList)));
        } else {
            void var5_6;
            boolean bl = false;
            while (var5_6 < 3) {
                void start = var5_6 * batchCount;
                void end = start + batchCount;
                futureList.add(this.decompressService.submit(new DecompressCallable(decompressorList.subList((int)start, (int)end))));
                ++var5_6;
            }
            futureList.add(this.decompressService.submit(new DecompressCallable(decompressorList.subList(batchCount * 3, size))));
        }
        for (Future future : futureList) {
            try {
                future.get(1L, TimeUnit.MINUTES);
            }
            catch (InterruptedException e) {
                LOGGER.debug("execute is error:", (Throwable)e);
            }
            catch (ExecutionException e) {
                DecompressThreadPool.doMyException(e);
            }
            catch (TimeoutException e) {
                e.printStackTrace();
            }
        }
    }

    private static void doMyException(ExecutionException e) {
        Throwable throwable = e.getCause();
        while (throwable != null) {
            if (throwable instanceof StopImportException) {
                throw (StopImportException)throwable;
            }
            if (throwable instanceof ProcessExitException) {
                throw (ProcessExitException)throwable;
            }
            if (throwable instanceof DiskNotEnoughException) {
                throw (DiskNotEnoughException)throwable;
            }
            throwable = throwable.getCause();
        }
    }

    public void destroy() {
        if (this.decompressService != null) {
            this.decompressService.shutdown();
            this.decompressService = null;
        }
    }
}

