/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.faulttree.expression;

import com.huawei.ism.tool.loganalyzer.faulttree.configuration.cache.RuleCache;
import com.huawei.ism.tool.loganalyzer.faulttree.configuration.model.rule.Rule;
import com.huawei.ism.tool.loganalyzer.faulttree.exception.ExpressionWrongException;
import com.huawei.ism.tool.loganalyzer.faulttree.exception.LogicCalculateException;
import com.huawei.ism.tool.loganalyzer.faulttree.expression.element.ResultElement;
import com.huawei.ism.tool.loganalyzer.faulttree.expression.templet.LogicElement;
import com.huawei.ism.tool.loganalyzer.faulttree.expression.templet.LogicOperator;
import com.huawei.ism.tool.loganalyzer.faulttree.expression.templet.OperatorElement;
import com.huawei.ism.tool.loganalyzer.faulttree.rulesearch.cache.RuleMatchResultCache;
import com.huawei.ism.tool.loganalyzer.faulttree.rulesearch.model.CauseMatchResult;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class LogicExpression {
    private Stack<String> operatorStack = new Stack();
    private Stack<OperatorElement> postfixStack = new Stack();
    private String logicExpressionStr;
    private RuleCache ruleCache;

    public LogicExpression(String logicExpression, RuleCache ruleCache) {
        this.logicExpressionStr = logicExpression;
        this.ruleCache = ruleCache;
        this.parse();
        if (this.postfixStack.size() == 1) {
            this.postfixStack.add(new ResultElement(true));
            this.postfixStack.add(LogicOperator.AND);
        }
        this.validExpression();
    }

    public Map<String, Rule> getRuleMap() {
        HashMap<String, Rule> ruleMap = new HashMap<String, Rule>();
        for (OperatorElement operatorElement : this.postfixStack) {
            List<Rule> ruleList;
            if (!(operatorElement instanceof LogicElement) || (ruleList = ((LogicElement)operatorElement).getRuleList()) == null) continue;
            for (Rule rule : ruleList) {
                ruleMap.put(rule.getId(), rule);
            }
        }
        return ruleMap;
    }

    public CauseMatchResult exec(RuleMatchResultCache resultCache) {
        CauseMatchResult matchResult = new CauseMatchResult(this.logicExpressionStr);
        Stack<OperatorElement> calculateStack = new Stack<OperatorElement>();
        int i = 0;
        while (i < this.postfixStack.size()) {
            OperatorElement operatorElement = (OperatorElement)this.postfixStack.get(i);
            if (operatorElement instanceof LogicElement) {
                calculateStack.add(operatorElement);
            } else if (operatorElement instanceof LogicOperator) {
                LogicElement top = (LogicElement)calculateStack.pop();
                LogicElement secondTop = (LogicElement)calculateStack.pop();
                boolean calResult = ((LogicOperator)operatorElement).operate(top, secondTop, resultCache, matchResult);
                ResultElement re = new ResultElement(calResult);
                if (i == this.postfixStack.size() - 1) {
                    matchResult.setMatch(calResult);
                } else {
                    calculateStack.add(re);
                }
            }
            ++i;
        }
        if (!calculateStack.isEmpty()) {
            throw new LogicCalculateException("Executing the Logic-operation occor an error:" + this.logicExpressionStr);
        }
        return matchResult;
    }

    private void parse() {
        String[] elements;
        String[] stringArray = elements = this.logicExpressionStr.replaceAll("\\(", " ( ").replaceAll("\\)", " ) ").trim().split("\\s+");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if (element.equals("(")) {
                this.operatorStack.add(element);
            } else if (element.equals(")")) {
                String operator = null;
                while ((operator = this.operatorStack.pop()) != null && !operator.equals("(")) {
                    this.postfixStack.add(LogicOperator.getOperator(operator));
                }
            } else if (LogicOperator.contains(element)) {
                if (!this.operatorStack.isEmpty() && LogicOperator.contains(this.operatorStack.peek())) {
                    this.postfixStack.add(LogicOperator.getOperator(this.operatorStack.pop()));
                }
                this.operatorStack.add(element);
            } else {
                this.postfixStack.add(LogicElement.getElement(element, this.ruleCache));
            }
            ++n2;
        }
        this.parseEnd();
    }

    private void validExpression() {
        Stack<OperatorElement> calculateStack = new Stack<OperatorElement>();
        int i = 0;
        while (i < this.postfixStack.size()) {
            OperatorElement operatorElement = (OperatorElement)this.postfixStack.get(i);
            if (operatorElement instanceof LogicElement) {
                calculateStack.add(operatorElement);
            } else if (operatorElement instanceof LogicOperator) {
                calculateStack.pop();
                calculateStack.pop();
                ResultElement re = new ResultElement(false);
                if (i != this.postfixStack.size() - 1) {
                    calculateStack.add(re);
                }
            }
            ++i;
        }
        if (!calculateStack.isEmpty()) {
            throw new LogicCalculateException("LogicExpression-format is wrong:" + this.logicExpressionStr);
        }
    }

    private void parseEnd() {
        if (!this.operatorStack.isEmpty()) {
            if (!LogicOperator.contains(this.operatorStack.peek())) {
                throw new ExpressionWrongException("Logic expression is wrong-1, please check:" + this.logicExpressionStr);
            }
            this.postfixStack.add(LogicOperator.getOperator(this.operatorStack.pop()));
            if (!this.operatorStack.isEmpty()) {
                throw new ExpressionWrongException("Logic expression is wrong-2, please check:" + this.logicExpressionStr);
            }
        }
    }
}

