/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.loganalyzer.faulttree.expression.element;

import com.huawei.ism.tool.loganalyzer.faulttree.configuration.cache.RuleCache;
import com.huawei.ism.tool.loganalyzer.faulttree.configuration.model.rule.Rule;
import com.huawei.ism.tool.loganalyzer.faulttree.exception.RuleNotFoundException;
import com.huawei.ism.tool.loganalyzer.faulttree.expression.templet.LogicElement;
import com.huawei.ism.tool.loganalyzer.faulttree.rulesearch.cache.RuleMatchResultCache;
import com.huawei.ism.tool.loganalyzer.faulttree.rulesearch.model.CauseMatchResult;
import com.huawei.ism.tool.loganalyzer.faulttree.rulesearch.model.RecordInfo;
import com.huawei.ism.tool.loganalyzer.faulttree.rulesearch.model.ResultCombination;
import com.huawei.ism.tool.loganalyzer.faulttree.util.CombinationUtil;
import java.util.ArrayList;
import java.util.List;

public class CommonElement
extends LogicElement {
    private Rule rule;
    private boolean reverse;

    public CommonElement(String ruleId, RuleCache ruleCache) {
        this.expression = ruleId;
        if (ruleId.charAt(0) == '!') {
            this.reverse = true;
            ruleId = ruleId.substring(1);
        }
        this.rule = ruleCache.getRule(ruleId);
        if (this.rule == null) {
            throw new RuleNotFoundException("Can't find the rule object by ruleId: " + ruleId);
        }
    }

    @Override
    public boolean exec(RuleMatchResultCache resultCache, CauseMatchResult matchResult) {
        if (resultCache.getRecordResultList(this.rule) == null) {
            return false;
        }
        matchResult.addRecordInfoList(this.rule.getId(), resultCache.getRecordResultList(this.rule));
        ResultCombination rc = new ResultCombination(this.expression);
        ArrayList list = new ArrayList();
        list.add(resultCache.getRecordResultList(this.rule));
        List allCombinations = CombinationUtil.getAllCombinations(list);
        for (List<RecordInfo> list2 : allCombinations) {
            rc.add(list2);
        }
        matchResult.addResultCombination(rc);
        return this.reverse ? !rc.find() : rc.find();
    }

    @Override
    public List<Rule> getRuleList() {
        ArrayList<Rule> ruleList = new ArrayList<Rule>(1);
        ruleList.add(this.rule);
        return ruleList;
    }
}

